/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public interface ColGroupUtils {
    public static double[] binaryDefRowLeft(BinaryOperator op, double[] v, IColIndex colIndexes) {
        ValueFunction fn = op.fn;
        int len = colIndexes.size();
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = fn.execute(v[colIndexes.get(i)], 0.0);
        }
        return ret;
    }

    public static double[] binaryDefRowRight(BinaryOperator op, double[] v, IColIndex colIndexes) {
        ValueFunction fn = op.fn;
        int len = colIndexes.size();
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = fn.execute(0.0, v[colIndexes.get(i)]);
        }
        return ret;
    }

    public static void copyValuesColGroupMatrixBlocks(AColGroup lhs, AColGroup rhs, MatrixBlock tmpResult, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        if (tmpResult.isEmpty()) {
            return;
        }
        if (tmpResult.isInSparseFormat()) {
            SparseBlock sb = tmpResult.getSparseBlock();
            for (int row = 0; row < lhs._colIndexes.size(); ++row) {
                if (sb.isEmpty(row)) continue;
                int apos = sb.pos(row);
                int alen = sb.size(row) + apos;
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                int offRes = lhs._colIndexes.get(row) * result.getNumColumns();
                for (int col = apos; col < alen; ++col) {
                    int n = offRes + rhs._colIndexes.get(aix[col]);
                    resV[n] = resV[n] + avals[col];
                }
            }
        } else {
            double[] tmpRetV = tmpResult.getDenseBlockValues();
            for (int row = 0; row < lhs.getNumCols(); ++row) {
                int offRes = lhs._colIndexes.get(row) * result.getNumColumns();
                int offTmp = row * rhs.getNumCols();
                for (int col = 0; col < rhs.getNumCols(); ++col) {
                    int n = offRes + rhs._colIndexes.get(col);
                    resV[n] = resV[n] + tmpRetV[offTmp + col];
                }
            }
        }
    }

    public static double[] extractMostCommonValueInColumns(MatrixBlock mb) {
        int i;
        int nCol = mb.getNumColumns();
        int nVal = mb.getNumRows();
        int[] nnz = LibMatrixReorg.countNnzPerColumn(mb);
        double[] ref = new double[nCol];
        boolean contains = false;
        for (i = 0; i < nCol; ++i) {
            if (nnz[i] <= nVal / 2) continue;
            contains = true;
            ref[i] = 1.0;
        }
        if (!contains) {
            return null;
        }
        ColGroupUtils.getMostCommonValues(mb, ref, nnz);
        contains = false;
        for (i = 0; i < nCol; ++i) {
            if (ref[i] == 0.0) continue;
            contains = true;
            break;
        }
        if (!contains) {
            return null;
        }
        return ref;
    }

    public static double refSum(double[] reference) {
        double ret = 0.0;
        for (double d : reference) {
            ret += d;
        }
        return ret;
    }

    public static double refSumSq(double[] reference) {
        double ret = 0.0;
        for (double d : reference) {
            ret += d * d;
        }
        return ret;
    }

    public static boolean allZero(double[] in) {
        for (double v : in) {
            if (v == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean containsInfOrNan(double pattern, double[] reference) {
        if (Double.isNaN(pattern)) {
            for (double d : reference) {
                if (!Double.isNaN(d)) continue;
                return true;
            }
            return false;
        }
        for (double d : reference) {
            if (!Double.isInfinite(d)) continue;
            return true;
        }
        return false;
    }

    public static double[] createReference(int nCol, double val) {
        double[] reference = new double[nCol];
        for (int i = 0; i < nCol; ++i) {
            reference[i] = val;
        }
        return reference;
    }

    public static double[] unaryOperator(UnaryOperator op, double[] reference) {
        double[] newRef = new double[reference.length];
        for (int i = 0; i < reference.length; ++i) {
            newRef[i] = op.fn.execute(reference[i]);
        }
        return newRef;
    }

    public static void outerProduct(double[] leftRowSum, double[] rightColumnSum, double[] result, int rl, int ru) {
        for (int row = rl; row < ru; ++row) {
            int offOut = rightColumnSum.length * row;
            double vLeft = leftRowSum[row];
            for (int col = 0; col < rightColumnSum.length; ++col) {
                int n = offOut + col;
                result[n] = result[n] + vLeft * rightColumnSum[col];
            }
        }
    }

    public static void outerProduct(double[] leftRowSum, double[] rightColumnSum, IColIndex colIdxRight, double[] result, int nColR, int rl, int ru) {
        for (int row = rl; row < ru; ++row) {
            int offOut = nColR * row;
            double vLeft = leftRowSum[row];
            for (int col = 0; col < rightColumnSum.length; ++col) {
                int n = offOut + colIdxRight.get(col);
                result[n] = result[n] + vLeft * rightColumnSum[col];
            }
        }
    }

    public static void outerProduct(double[] leftRowSum, SparseBlock rightColSum, IColIndex colIdxRight, double[] result, int nColR, int rl, int ru) {
        int alen = rightColSum.size(0);
        int[] aix = rightColSum.indexes(0);
        double[] aval = rightColSum.values(0);
        for (int row = rl; row < ru; ++row) {
            int offOut = nColR * row;
            double vLeft = leftRowSum[row];
            for (int j = 0; j < alen; ++j) {
                int n = offOut + colIdxRight.get(aix[j]);
                result[n] = result[n] + vLeft * aval[j];
            }
        }
    }

    private static void getMostCommonValues(MatrixBlock mb, double[] ref, int[] nnzCols) {
        DoubleCountHashMap[] counters = new DoubleCountHashMap[ref.length];
        if (mb.isInSparseFormat()) {
            for (int i = 0; i < ref.length; ++i) {
                if (ref[i] == 0.0) continue;
                counters[i] = new DoubleCountHashMap(8);
                counters[i].increment(0.0, nnzCols[i]);
            }
            SparseBlock sb = mb.getSparseBlock();
            for (int r = 0; r < mb.getNumRows(); ++r) {
                if (sb.isEmpty(r)) continue;
                int apos = sb.pos(r);
                int alen = sb.size(r) + apos;
                int[] aix = sb.indexes(r);
                double[] aval = sb.values(r);
                for (int j = apos; j < alen; ++j) {
                    if (ref[aix[j]] == 0.0) continue;
                    counters[aix[j]].increment(aval[j]);
                }
            }
        } else {
            for (int i = 0; i < ref.length; ++i) {
                if (ref[i] == 0.0) continue;
                counters[i] = new DoubleCountHashMap(8);
            }
            double[] dv = mb.getDenseBlockValues();
            int nCol = ref.length;
            for (int r = 0; r < mb.getNumRows(); ++r) {
                int rOff = r * nCol;
                for (int c = 0; c < nCol; ++c) {
                    if (ref[c] == 0.0) continue;
                    counters[c].increment(dv[rOff + c]);
                }
            }
        }
        for (int i = 0; i < ref.length; ++i) {
            if (ref[i] == 0.0) continue;
            ref[i] = counters[i].getMostFrequent();
        }
    }

    public static void addMatrixToResult(MatrixBlock tmp, MatrixBlock result, IColIndex colIndexes, int rl, int ru) {
        if (tmp.isEmpty()) {
            return;
        }
        double[] retV = result.getDenseBlockValues();
        int nColRet = result.getNumColumns();
        if (tmp.isInSparseFormat()) {
            SparseBlock sb = tmp.getSparseBlock();
            int row = rl;
            int offT = 0;
            while (row < ru) {
                int apos = sb.pos(offT);
                int alen = sb.size(offT);
                int[] aix = sb.indexes(offT);
                double[] avals = sb.values(offT);
                int offR = row * nColRet;
                for (int i = apos; i < apos + alen; ++i) {
                    int n = offR + colIndexes.get(aix[i]);
                    retV[n] = retV[n] + avals[i];
                }
                ++row;
                ++offT;
            }
        } else {
            double[] tmpV = tmp.getDenseBlockValues();
            int nCol = colIndexes.size();
            int row = rl;
            int offT = 0;
            while (row < ru) {
                int offR = row * nColRet;
                for (int col = 0; col < nCol; ++col) {
                    int n = offR + colIndexes.get(col);
                    retV[n] = retV[n] + tmpV[offT + col];
                }
                ++row;
                offT += nCol;
            }
        }
    }
}

