/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.ShuffleDataIOUtils$;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.sort.PackedRecordPointer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.mutable.ArrayOps;

public final class SortShuffleManager$
implements Logging {
    public static SortShuffleManager$ MODULE$;
    private final int MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE;
    private final String FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SortShuffleManager$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE() {
        return this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE;
    }

    public String FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY() {
        return this.FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseBatchFetch(int startPartition, int endPartition, TaskContext context) {
        if (endPartition - startPartition <= 1) return false;
        boolean bl = true;
        boolean fetchMultiPartitions = bl;
        if (!fetchMultiPartitions) return false;
        String string = context.getLocalProperty(this.FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY());
        String string2 = "true";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean canUseSerializedShuffle(ShuffleDependency<?, ?, ?> dependency) {
        int shufId = dependency.shuffleId();
        int numPartitions = dependency.partitioner().numPartitions();
        if (!dependency.serializer().supportsRelocationOfSerializedObjects()) {
            this.log().debug(new StringBuilder(102).append("Can't use serialized shuffle for shuffle ").append(shufId).append(" because the serializer, ").append(dependency.serializer().getClass().getName()).append(", does not support object relocation").toString());
            return false;
        }
        if (dependency.mapSideCombine()) {
            this.log().debug(new StringBuilder(84).append("Can't use serialized shuffle for shuffle ").append(shufId).append(" because we need to do ").append("map-side aggregation").toString());
            return false;
        }
        if (numPartitions > this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()) {
            this.log().debug(new StringBuilder(78).append("Can't use serialized shuffle for shuffle ").append(shufId).append(" because it has more than ").append(this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()).append(" partitions").toString());
            return false;
        }
        this.log().debug(new StringBuilder(39).append("Can use serialized shuffle for shuffle ").append(shufId).toString());
        return true;
    }

    public ShuffleExecutorComponents org$apache$spark$shuffle$sort$SortShuffleManager$$loadShuffleExecutorComponents(SparkConf conf) {
        ShuffleExecutorComponents executorComponents = ShuffleDataIOUtils$.MODULE$.loadShuffleDataIO(conf).executor();
        scala.collection.immutable.Map extraConfigs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAllWithPrefix(ShuffleDataIOUtils$.MODULE$.SHUFFLE_SPARK_CONF_PREFIX()))).toMap(Predef$.MODULE$.$conforms());
        executorComponents.initializeExecutor(conf.getAppId(), SparkEnv$.MODULE$.get().executorId(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraConfigs).asJava());
        return executorComponents;
    }

    private SortShuffleManager$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE = PackedRecordPointer.MAXIMUM_PARTITION_ID + 1;
        this.FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY = "__fetch_continuous_blocks_in_batch_enabled";
    }
}

