/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;

public class Symbols
implements Localized,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1730166945430878916L;
    static final boolean SCIENTIFIC_NOTATION = true;
    static final char NUMBER_SEPARATOR = ' ';
    static final char FRAGMENT_VALUE = '$';
    public static final Symbols SQUARE_BRACKETS = new Symbols(new int[]{91, 93, 40, 41}, new int[]{34, 34, 8220, 8221});
    public static final Symbols CURLY_BRACKETS = new Symbols(new int[]{40, 41, 91, 93}, Symbols.SQUARE_BRACKETS.quotes);
    private Locale locale;
    private int[] brackets;
    private int[] quotes;
    private transient String quote;
    private int openSequence;
    private int closeSequence;
    private String separator;
    private transient String trimmedSeparator;
    private boolean isImmutable;

    public Symbols(Symbols symbols) {
        ArgumentChecks.ensureNonNull("symbols", symbols);
        this.locale = symbols.locale;
        this.brackets = symbols.brackets;
        this.quotes = symbols.quotes;
        this.quote = symbols.quote;
        this.openSequence = symbols.openSequence;
        this.closeSequence = symbols.closeSequence;
        this.separator = symbols.separator;
        this.trimmedSeparator = symbols.trimmedSeparator;
    }

    private Symbols(int[] brackets, int[] quotes) {
        this.locale = Locale.ROOT;
        this.brackets = brackets;
        this.quotes = quotes;
        this.quote = "\"";
        this.openSequence = 123;
        this.closeSequence = 125;
        this.separator = ", ";
        this.trimmedSeparator = ",";
        this.isImmutable = true;
    }

    private void checkWritePermission() throws UnsupportedOperationException {
        if (this.isImmutable) {
            throw new UnsupportedOperationException(Errors.format((short)153, "Symbols"));
        }
    }

    public static Symbols getDefault() {
        return SQUARE_BRACKETS;
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.checkWritePermission();
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
    }

    private static int matching(int[] chars, int c) {
        for (int i = 0; i < chars.length; i += 2) {
            if (chars[i] != c) continue;
            return chars[i + 1];
        }
        return -1;
    }

    final int matchingBracket(int c) {
        return Symbols.matching(this.brackets, c);
    }

    public final int getNumPairedBrackets() {
        return this.brackets.length >>> 1;
    }

    public final int getOpeningBracket(int index) {
        return this.brackets[index << 1];
    }

    public final int getClosingBracket(int index) {
        return this.brackets[index << 1 | 1];
    }

    public void setPairedBrackets(String preferred, String ... alternatives) {
        this.checkWritePermission();
        this.brackets = Symbols.toCodePoints(preferred, alternatives);
    }

    final int matchingQuote(int c) {
        return Symbols.matching(this.quotes, c);
    }

    public final int getNumPairedQuotes() {
        return this.quotes.length >>> 1;
    }

    public final int getOpeningQuote(int index) {
        return this.quotes[index << 1];
    }

    public final int getClosingQuote(int index) {
        return this.quotes[index << 1 | 1];
    }

    final String getQuote() {
        return this.quote;
    }

    public void setPairedQuotes(String preferred, String ... alternatives) {
        this.checkWritePermission();
        this.quotes = Symbols.toCodePoints(preferred, alternatives);
        this.quote = preferred.substring(Character.charCount(this.quotes[0])).trim();
    }

    private static int[] toCodePoints(String preferred, String[] alternatives) {
        ArgumentChecks.ensureNonEmpty("preferred", preferred);
        int n = alternatives != null ? alternatives.length : 0;
        int[] array = new int[(n + 1) * 2];
        String name = "preferred";
        String pair = preferred;
        int i = 0;
        int j = 0;
        while (true) {
            if (pair.codePointCount(0, pair.length()) != 2) {
                throw new IllegalArgumentException(Errors.format((short)45, name, pair));
            }
            int c = pair.codePointAt(0);
            int n2 = j++;
            int n3 = c;
            array[n2] = n3;
            Symbols.ensureValidQuoteOrBracket(name, n3);
            int n4 = j++;
            int n5 = pair.codePointAt(Character.charCount(c));
            array[n4] = n5;
            Symbols.ensureValidQuoteOrBracket(name, n5);
            if (i >= n) break;
            name = "alternatives";
            int n6 = i;
            pair = alternatives[i++];
            ArgumentChecks.ensureNonNullElement("alternatives", n6, pair);
        }
        return array;
    }

    private static void ensureValidQuoteOrBracket(String name, int code) {
        ArgumentChecks.ensureValidUnicodeCodePoint(name, code);
        if (Character.isUnicodeIdentifierPart(code) || Character.isSpaceChar(code) || code == 36) {
            throw new IllegalArgumentException(Errors.format((short)49, name, String.valueOf(Character.toChars(code))));
        }
    }

    public final int getOpenSequence() {
        return this.openSequence;
    }

    public final int getCloseSequence() {
        return this.closeSequence;
    }

    public void setSequenceBrackets(int openSequence, int closeSequence) {
        this.checkWritePermission();
        Symbols.ensureValidQuoteOrBracket("openSequence", openSequence);
        Symbols.ensureValidQuoteOrBracket("closeSequence", closeSequence);
        this.openSequence = openSequence;
        this.closeSequence = closeSequence;
    }

    public final String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.checkWritePermission();
        this.trimmedSeparator = separator.trim().strip();
        ArgumentChecks.ensureNonEmpty("separator", this.trimmedSeparator);
        this.separator = separator;
    }

    final String trimmedSeparator() {
        return this.trimmedSeparator;
    }

    final String separatorNewLine() {
        String separator = this.getSeparator();
        return separator.substring(0, CharSequences.skipTrailingWhitespaces(separator, 0, separator.length())).concat(System.lineSeparator());
    }

    final NumberFormat createNumberFormat() {
        NumberFormat format = NumberFormat.getNumberInstance(this.locale);
        format.setGroupingUsed(false);
        return format;
    }

    final boolean useScientificNotation(double abs) {
        return (abs < 0.001 || abs >= 1.0E9) && this.locale == Locale.ROOT;
    }

    public boolean containsElement(CharSequence wkt, String element) {
        ArgumentChecks.ensureNonNull("wkt", wkt);
        ArgumentChecks.ensureNonEmpty("element", element);
        if (!CharSequences.isUnicodeIdentifier(element)) {
            throw new IllegalArgumentException(Errors.format((short)112, element));
        }
        return this.containsElement(wkt, element, 0);
    }

    private boolean containsElement(CharSequence wkt, String element, int offset) {
        int[] quotes = this.quotes;
        int length = wkt.length();
        boolean isQuoting = false;
        int closeQuote = 0;
        while (offset < length) {
            int c;
            block8: {
                block7: {
                    c = Character.codePointAt(wkt, offset);
                    if (closeQuote == 0) break block7;
                    if (c != closeQuote) break block8;
                    isQuoting = false;
                    break block8;
                }
                for (int i = 0; i < quotes.length; i += 2) {
                    if (c != quotes[i]) continue;
                    closeQuote = quotes[i | 1];
                    isQuoting = true;
                    break;
                }
            }
            if (!isQuoting && Character.isUnicodeIdentifierStart(c)) {
                if (CharSequences.regionMatches(wkt, offset, element, true)) {
                    if ((offset = CharSequences.skipLeadingWhitespaces(wkt, offset + element.length(), length)) >= length) break;
                    c = Character.codePointAt(wkt, offset);
                    if (this.matchingBracket(c) >= 0) {
                        return true;
                    }
                } else {
                    do {
                        if ((offset += Character.charCount(c)) < length) continue;
                        return false;
                    } while (Character.isUnicodeIdentifierPart(c = Character.codePointAt(wkt, offset)));
                }
            }
            offset += Character.charCount(c);
        }
        return false;
    }

    final Symbols immutable() {
        if (this.isImmutable) {
            return this;
        }
        Symbols clone = this.clone();
        clone.isImmutable = true;
        return clone;
    }

    public Symbols clone() {
        Symbols clone;
        try {
            clone = (Symbols)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        clone.isImmutable = false;
        return clone;
    }

    public boolean equals(Object other) {
        if (other instanceof Symbols) {
            Symbols that = (Symbols)other;
            return Arrays.equals(this.brackets, that.brackets) && Arrays.equals(this.quotes, that.quotes) && this.openSequence == that.openSequence && this.closeSequence == that.closeSequence && this.separator.equals(that.separator) && this.locale.equals(that.locale);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.brackets, this.quotes, this.openSequence, this.closeSequence, this.separator, this.locale});
    }

    final Object readResolve() throws ObjectStreamException {
        if (this.isImmutable) {
            if (this.equals(SQUARE_BRACKETS)) {
                return SQUARE_BRACKETS;
            }
            if (this.equals(CURLY_BRACKETS)) {
                return CURLY_BRACKETS;
            }
        }
        this.quote = String.valueOf(Character.toChars(this.quotes[1]));
        this.trimmedSeparator = this.separator.trim().strip();
        return this;
    }
}

