/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.image;

import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.PRJDataStore;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.image.FormatFilter;
import org.apache.sis.storage.image.FormatFinder;
import org.apache.sis.storage.image.MultiImageStore;
import org.apache.sis.storage.image.SingleImageStore;
import org.apache.sis.storage.image.WorldFileStore;
import org.apache.sis.storage.image.WritableSingleImageStore;
import org.apache.sis.util.ArraysExt;

@StoreMetadata(formatName="World file", fileSuffixes={"jpeg", "jpg", "png", "gif", "bmp"}, capabilities={Capability.READ, Capability.WRITE, Capability.CREATE}, resourceTypes={Aggregate.class, GridCoverageResource.class})
public final class WorldFileStoreProvider
extends PRJDataStore.Provider {
    static final String NAME = "World file";
    private static final String[] SINGLE_IMAGE_FORMATS = new String[]{"PNG", "BMP", "WBMP", "JPEG"};
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.image");
    private final boolean allowSingleton;

    public WorldFileStoreProvider() {
        this.allowSingleton = true;
    }

    public WorldFileStoreProvider(boolean allowSingleton) {
        this.allowSingleton = allowSingleton;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public WorldFileStore open(StorageConnector connector) throws DataStoreException {
        WorldFileStore store;
        try (FormatFinder format = new FormatFinder(this, connector);){
            String[] names;
            boolean isSingleton = false;
            if (this.allowSingleton && (names = format.getFormatName()) != null) {
                String name;
                String[] stringArray = names;
                int n = stringArray.length;
                for (int i = 0; i < n && !(isSingleton = ArraysExt.containsIgnoreCase(SINGLE_IMAGE_FORMATS, name = stringArray[i])); ++i) {
                }
            }
            store = format.isWritable ? (isSingleton ? new WritableSingleImageStore(format) : new MultiImageStore.Writable(format)) : (isSingleton ? new SingleImageStore(format) : new MultiImageStore(format));
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        return store;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        ImageReaderSpi provider;
        HashSet<ImageReaderSpi> deferred = new HashSet<ImageReaderSpi>();
        String suffix = IOUtilities.extension(connector.getStorage());
        try {
            provider = FormatFilter.SUFFIX.findProvider(suffix, connector, deferred);
            if (provider == null) {
                if (suffix != null) {
                    provider = FormatFilter.SUFFIX.findProvider(null, connector, deferred);
                }
                if (provider == null) {
                    return ProbeResult.UNSUPPORTED_STORAGE;
                }
            }
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        String[] types = provider.getMIMETypes();
        if (types != null && types.length != 0) {
            return new ProbeResult(true, types[0], null);
        }
        return ProbeResult.SUPPORTED;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }
}

