/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.csv;

import java.util.Objects;
import org.apache.tika.mime.MediaType;

public class CSVResult
implements Comparable<CSVResult> {
    static CSVResult TEXT = new CSVResult(1.0, MediaType.TEXT_PLAIN, null);
    private final double confidence;
    private final MediaType mediaType;
    private final Character delimiter;

    public CSVResult(double confidence, MediaType mediaType, Character delimiter) {
        this.confidence = confidence;
        this.mediaType = mediaType;
        this.delimiter = delimiter;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    @Override
    public int compareTo(CSVResult o) {
        return Double.compare(o.confidence, this.confidence);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSVResult csvResult = (CSVResult)o;
        return Double.compare(csvResult.confidence, this.confidence) == 0 && this.mediaType.equals((Object)csvResult.mediaType) && Objects.equals(this.delimiter, csvResult.delimiter);
    }

    public int hashCode() {
        return Objects.hash(this.confidence, this.mediaType, this.delimiter);
    }

    public String toString() {
        return "CSVResult{confidence=" + this.confidence + ", mediaType=" + String.valueOf(this.mediaType) + ", delimiter=" + this.delimiter + "}";
    }

    public double getConfidence() {
        return this.confidence;
    }
}

