/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import org.quartz.JobExecutionContext;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;

public class JobExecutionProcessException
extends SchedulerException {
    private final JobExecutionContext jobExecutionContext;

    public JobExecutionProcessException(JobExecutionContext jobExecutionContext, Throwable cause) {
        super(ProcessErrorMessage.JobExecution.errorMsg, cause);
        this.jobExecutionContext = jobExecutionContext;
    }

    public JobExecutionProcessException(JobListener listener, JobExecutionContext jobExecutionContext, Throwable cause) {
        super(String.format(ProcessErrorMessage.JobListenerExecution.getErrorMsg(), listener.getName(), cause.getMessage()), cause);
        this.jobExecutionContext = jobExecutionContext;
    }

    public JobExecutionProcessException(TriggerListener listener, JobExecutionContext jobExecutionContext, Throwable cause) {
        super(String.format(ProcessErrorMessage.TriggerListenerExecution.getErrorMsg(), listener.getName(), cause.getMessage()), cause);
        this.jobExecutionContext = jobExecutionContext;
    }

    public JobExecutionContext getJobExecutionContext() {
        return this.jobExecutionContext;
    }

    static enum ProcessErrorMessage {
        JobExecution("Job threw an unhandled exception"),
        JobListenerExecution("JobListener '%s' threw exception: %s."),
        TriggerListenerExecution("TriggerListener '%s' threw exception: %s.");

        private final String errorMsg;

        private ProcessErrorMessage(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }
    }
}

