/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.jsr223.AbstractGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.DefaultScriptCustomizer;

public final class ScriptFileGremlinPlugin
extends AbstractGremlinPlugin {
    private static final String NAME = "tinkerpop.script";

    private ScriptFileGremlinPlugin(Builder builder) {
        super(NAME, builder.appliesTo, new DefaultScriptCustomizer(builder.files));
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private final Set<String> appliesTo = new HashSet<String>();
        private List<File> files = new ArrayList<File>();

        private Builder() {
        }

        public Builder appliesTo(Collection<String> scriptEngineNames) {
            this.appliesTo.addAll(scriptEngineNames);
            return this;
        }

        public Builder files(List<String> files) {
            for (String f : files) {
                File file = new File(f);
                if (!file.exists()) {
                    throw new IllegalArgumentException(new FileNotFoundException(f));
                }
                this.files.add(file);
            }
            return this;
        }

        public ScriptFileGremlinPlugin create() {
            return new ScriptFileGremlinPlugin(this);
        }
    }
}

