/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.parameters;

import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.ReferenceType;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.media.ExampleObjectIO;
import io.smallrye.openapi.runtime.io.media.SchemaIO;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.annotations.enums.Explode;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ParameterIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Parameter, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_ALLOW_EMPTY_VALUE = "allowEmptyValue";
    private static final String PROP_ALLOW_RESERVED = "allowReserved";
    private static final String PROP_CONTENT = "content";
    private static final String PROP_DEPRECATED = "deprecated";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_EXAMPLE = "example";
    private static final String PROP_EXAMPLES = "examples";
    private static final String PROP_EXPLODE = "explode";
    private static final String PROP_HIDDEN = "hidden";
    private static final String PROP_IN = "in";
    private static final String PROP_NAME = "name";
    private static final String PROP_REQUIRED = "required";
    private static final String PROP_SCHEMA = "schema";
    private static final String PROP_STYLE = "style";
    private final SchemaIO<V, A, O, AB, OB> schemaIO;
    private final ContentIO<V, A, O, AB, OB> contentIO;
    private final ExampleObjectIO<V, A, O, AB, OB> exampleObjectIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public ParameterIO(IOContext<V, A, O, AB, OB> context, ContentIO<V, A, O, AB, OB> contentIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.PARAMETER, Names.create(Parameter.class));
        this.contentIO = contentIO;
        this.exampleObjectIO = new ExampleObjectIO<V, A, O, AB, OB>(context, extensionIO);
        this.schemaIO = new SchemaIO<V, A, O, AB, OB>(context, extensionIO);
        this.extensionIO = extensionIO;
    }

    public List<Parameter> readList(AnnotationValue annotations) {
        return Optional.ofNullable(annotations).map(AnnotationValue::asNestedArray).map(this::readList).orElse(null);
    }

    public List<Parameter> readList(AnnotationInstance[] annotations) {
        return this.readList((V)Arrays.asList(annotations));
    }

    public List<Parameter> readList(Collection<AnnotationInstance> annotations) {
        return annotations.stream().filter(ParameterIO.not(this::isReference)).map(this::read).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public Parameter read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@Parameter");
        ParameterImpl parameter = new ParameterImpl();
        parameter.setName((String)this.value(annotation, PROP_NAME));
        parameter.setIn(this.enumValue(annotation, PROP_IN, Parameter.In.class));
        if (Boolean.TRUE.equals(this.value(annotation, PROP_HIDDEN))) {
            ParameterImpl.setHidden(parameter, true);
            return parameter;
        }
        parameter.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        parameter.setRequired((Boolean)this.value(annotation, PROP_REQUIRED));
        parameter.setDeprecated((Boolean)this.value(annotation, PROP_DEPRECATED));
        parameter.setAllowEmptyValue((Boolean)this.value(annotation, PROP_ALLOW_EMPTY_VALUE));
        parameter.setStyle(this.enumValue(annotation, PROP_STYLE, Parameter.Style.class));
        parameter.setExplode(ParameterIO.readExplode(this.scannerContext(), annotation));
        parameter.setAllowReserved((Boolean)this.value(annotation, PROP_ALLOW_RESERVED));
        parameter.setSchema((Schema)this.schemaIO.read(annotation.value(PROP_SCHEMA)));
        parameter.setContent(this.contentIO.read(annotation.value(PROP_CONTENT), ContentIO.Direction.PARAMETER));
        parameter.setExamples(this.exampleObjectIO.readMap(annotation.value(PROP_EXAMPLES)));
        parameter.setExample(this.exampleObjectIO.parseValue((String)this.value(annotation, PROP_EXAMPLE)));
        parameter.setRef(ReferenceType.PARAMETER.refValue(annotation));
        if (annotation.target() != null) {
            switch (annotation.target().kind()) {
                case FIELD: 
                case METHOD_PARAMETER: {
                    parameter.setExtensions(this.extensionIO.readExtensible(annotation));
                    break;
                }
            }
            parameter.setParamRef(JandexUtil.createUniqueAnnotationTargetRef(annotation.target()));
        }
        return parameter;
    }

    public List<Parameter> readList(V node) {
        return Optional.ofNullable(node).filter(this.jsonIO()::isArray).map(this.jsonIO()::asArray).map(this.jsonIO()::entries).map(Collection::stream).map(elements -> {
            IoLogging.logger.jsonArray("Parameter");
            return elements.filter(this.jsonIO()::isObject).map(this.jsonIO()::asObject).map(this::readObject).collect(Collectors.toCollection(ArrayList::new));
        }).orElse(null);
    }

    @Override
    public Parameter readObject(O node) {
        IoLogging.logger.singleJsonObject("Parameter");
        ParameterImpl parameter = new ParameterImpl();
        parameter.setName(this.jsonIO().getString(node, PROP_NAME));
        parameter.setIn(this.enumValue(this.jsonIO().getValue(node, PROP_IN), Parameter.In.class));
        parameter.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        parameter.setRequired(this.jsonIO().getBoolean(node, PROP_REQUIRED));
        parameter.setDeprecated(this.jsonIO().getBoolean(node, PROP_DEPRECATED));
        parameter.setAllowEmptyValue(this.jsonIO().getBoolean(node, PROP_ALLOW_EMPTY_VALUE));
        parameter.setStyle(this.enumValue(this.jsonIO().getValue(node, PROP_STYLE), Parameter.Style.class));
        parameter.setExplode(this.jsonIO().getBoolean(node, PROP_EXPLODE));
        parameter.setAllowReserved(this.jsonIO().getBoolean(node, PROP_ALLOW_RESERVED));
        parameter.setSchema((Schema)this.schemaIO.readValue(this.jsonIO().getValue(node, PROP_SCHEMA)));
        parameter.setContent((Content)this.contentIO.readValue(this.jsonIO().getValue(node, PROP_CONTENT)));
        parameter.setExamples(this.exampleObjectIO.readMap(this.jsonIO().getValue(node, PROP_EXAMPLES)));
        parameter.setExample(this.jsonIO().fromJson(this.jsonIO().getValue(node, PROP_EXAMPLE)));
        parameter.setRef(this.readReference(node));
        parameter.setExtensions(this.extensionIO.readMap(node));
        return parameter;
    }

    @Override
    public Optional<A> write(List<Parameter> models) {
        return this.optionalJsonArray(models).map(array -> {
            models.forEach(model -> this.write((Parameter)model).ifPresent(v -> this.jsonIO().add(array, v)));
            return array;
        }).map(this.jsonIO()::buildArray);
    }

    @Override
    public Optional<O> write(Parameter model) {
        return this.optionalJsonObject(model).map(node -> {
            if (this.isReference((Reference<?>)model)) {
                this.setReference(node, (Reference<?>)model);
            } else {
                this.setIfPresent(node, PROP_NAME, this.jsonIO().toJson(model.getName()));
                this.setIfPresent(node, PROP_IN, this.jsonIO().toJson(model.getIn()));
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
                this.setIfPresent(node, PROP_REQUIRED, this.jsonIO().toJson(model.getRequired()));
                this.setIfPresent(node, PROP_SCHEMA, this.schemaIO.write(model.getSchema()));
                this.setIfPresent(node, PROP_ALLOW_EMPTY_VALUE, this.jsonIO().toJson(model.getAllowEmptyValue()));
                this.setIfPresent(node, PROP_DEPRECATED, this.jsonIO().toJson(model.getDeprecated()));
                this.setIfPresent(node, PROP_STYLE, this.jsonIO().toJson(model.getStyle()));
                this.setIfPresent(node, PROP_EXPLODE, this.jsonIO().toJson(model.getExplode()));
                this.setIfPresent(node, PROP_ALLOW_RESERVED, this.jsonIO().toJson(model.getAllowReserved()));
                this.setIfPresent(node, PROP_EXAMPLE, this.jsonIO().toJson(model.getExample()));
                this.setIfPresent(node, PROP_EXAMPLES, this.exampleObjectIO.write(model.getExamples()));
                this.setIfPresent(node, PROP_CONTENT, this.contentIO.write(model.getContent()));
                this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }

    private static Boolean readExplode(AnnotationScannerContext context, AnnotationInstance parameterAnnoatation) {
        Explode explode = context.annotations().enumValue(parameterAnnoatation, PROP_EXPLODE, Explode.class);
        if (explode == Explode.TRUE) {
            return Boolean.TRUE;
        }
        if (explode == Explode.FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }
}

