/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.ByteArrayOutputStream;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.signature.XMLSignatureException;

public class SignerOutputStream
extends ByteArrayOutputStream {
    private static final System.Logger LOG = System.getLogger(SignerOutputStream.class.getName());
    final SignatureAlgorithm sa;

    public SignerOutputStream(SignatureAlgorithm sa) {
        this.sa = sa;
    }

    @Override
    public void write(byte[] arg0) {
        try {
            this.sa.update(arg0);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }

    @Override
    public void write(int arg0) {
        try {
            this.sa.update((byte)arg0);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
            LOG.log(System.Logger.Level.DEBUG, "Canonicalized SignedInfo:");
            StringBuilder sb = new StringBuilder(arg2);
            for (int i = arg1; i < arg1 + arg2; ++i) {
                sb.append((char)arg0[i]);
            }
            LOG.log(System.Logger.Level.DEBUG, sb.toString());
        }
        try {
            this.sa.update(arg0, arg1, arg2);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }
}

