/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.generator.impl;

import com.google.common.xml.XmlEscapers;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.core.xml.Namespace;
import org.opensaml.saml.metadata.generator.impl.MetadataGenerator;
import org.opensaml.saml.metadata.generator.impl.MetadataGeneratorParameters;
import org.opensaml.saml.metadata.generator.impl.TemplateMetadataGeneratorParameters;

public class VelocityMetadataGenerator
extends AbstractIdentifiableInitializableComponent
implements MetadataGenerator {
    @NonnullAfterInit
    private VelocityEngine velocityEngine;

    public void setVelocityEngine(@Nonnull VelocityEngine engine) {
        this.velocityEngine = (VelocityEngine)Constraint.isNotNull((Object)engine, (String)"VelocityEngine cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.velocityEngine == null) {
            throw new ComponentInitializationException("VelocityEngine cannot be null");
        }
    }

    @Override
    public void generate(@Nonnull MetadataGeneratorParameters params, @Nonnull Writer sink) throws IOException {
        try {
            if (!(params instanceof TemplateMetadataGeneratorParameters)) {
                throw new IllegalArgumentException("Parameters were not of the expected type");
            }
            TemplateMetadataGeneratorParameters downcast = (TemplateMetadataGeneratorParameters)params;
            Template.fromTemplateName((VelocityEngine)this.velocityEngine, (String)(downcast.getTemplatePath() + "/EntityDescriptor.vm")).merge((Context)this.getVelocityContext(downcast), sink);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                IOException io = (IOException)e;
                throw io;
            }
            throw new IOException(e);
        }
    }

    @Nonnull
    protected VelocityContext getVelocityContext(@Nonnull TemplateMetadataGeneratorParameters params) {
        VelocityContext context = new VelocityContext();
        context.put("params", (Object)params);
        if (!params.isOmitNamespaceDeclarations()) {
            HashMap<String, String> prefixMap = new HashMap<String, String>();
            prefixMap.put("md", "urn:oasis:names:tc:SAML:2.0:metadata");
            prefixMap.put("ds", "http://www.w3.org/2000/09/xmldsig#");
            Set<Namespace> additionalNamespaces = params.getAdditionalNamespaces();
            if (additionalNamespaces != null) {
                for (Namespace ns : additionalNamespaces) {
                    prefixMap.put(ns.getNamespacePrefix(), ns.getNamespaceURI());
                }
            }
            context.put("namespaces", prefixMap);
        }
        context.put("xmltext", (Object)XmlEscapers.xmlContentEscaper());
        context.put("xmlattr", (Object)XmlEscapers.xmlAttributeEscaper());
        return context;
    }
}

