/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.dbcp;

import java.io.File;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.managed.DataSourceXAConnectionFactory;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.cipher.PasswordCipher;
import org.apache.openejb.cipher.PasswordCipherFactory;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.BasicDataSourceUtil;
import org.apache.openejb.resource.jdbc.IsolationLevels;
import org.apache.openejb.resource.jdbc.dbcp.DataSourceSerialization;
import org.apache.openejb.resource.jdbc.dbcp.JMXBasicDataSource;
import org.apache.openejb.resource.jdbc.plugin.DataSourcePlugin;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.reflection.Reflections;

public class BasicDataSource
extends org.apache.commons.dbcp2.BasicDataSource
implements Serializable {
    private volatile Logger logger;
    private volatile DataSource dsRef = null;
    private String passwordCipher;
    private String initialPassword;
    private JMXBasicDataSource jmxDs;
    private CommonDataSource delegate;
    private String name;

    public BasicDataSource() {
    }

    public BasicDataSource(String name) {
        this.setName(name);
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setDelegate(CommonDataSource delegate) {
        this.delegate = delegate;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        if (this.delegate != null) {
            if (XADataSource.class.isInstance(this.delegate)) {
                return new DataSourceXAConnectionFactory(OpenEJB.getTransactionManager(), (XADataSource)XADataSource.class.cast(this.delegate), this.getUsername(), this.getPassword());
            }
            return new DataSourceConnectionFactory((DataSource)DataSource.class.cast(this.delegate), this.getUsername(), this.getPassword());
        }
        return super.createConnectionFactory();
    }

    private void registerAsMbean(String name) {
        try {
            this.jmxDs = new JMXBasicDataSource(name, this);
        }
        catch (Exception | NoClassDefFoundError e) {
            this.jmxDs = null;
        }
    }

    public synchronized String getPasswordCipher() {
        return this.passwordCipher;
    }

    public synchronized void setPasswordCipher(String passwordCipher) {
        this.passwordCipher = passwordCipher;
    }

    public synchronized void setPassword(String password) {
        this.initialPassword = password;
        super.setPassword(password);
    }

    public synchronized String getUserName() {
        return super.getUsername();
    }

    public synchronized void setUserName(String string) {
        super.setUsername(string);
    }

    public synchronized String getJdbcDriver() {
        return super.getDriverClassName();
    }

    public synchronized void setJdbcDriver(String string) {
        super.setDriverClassName(string);
    }

    public synchronized String getJdbcUrl() {
        return super.getUrl();
    }

    public void setJdbcUrl(String string) {
        super.setUrl(string);
    }

    public synchronized void setDefaultTransactionIsolation(String s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        int level2 = IsolationLevels.getIsolationLevel(s);
        super.setDefaultTransactionIsolation(level2);
    }

    public synchronized void setMaxWait(int maxWait) {
        super.setMaxWaitMillis((long)maxWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource createDataSource() throws SQLException {
        if (this.dsRef != null) {
            return this.dsRef;
        }
        BasicDataSource basicDataSource = this;
        synchronized (basicDataSource) {
            String newUrl;
            String currentUrl;
            DataSourcePlugin helper;
            if (this.dsRef != null) {
                return this.dsRef;
            }
            if (null != this.passwordCipher && !"PlainText".equals(this.passwordCipher)) {
                PasswordCipher cipher = PasswordCipherFactory.getPasswordCipher(this.passwordCipher);
                String plainPwd = cipher.decrypt(this.initialPassword.toCharArray());
                super.setPassword(plainPwd);
            }
            if ((helper = BasicDataSourceUtil.getDataSourcePlugin(this.getUrl())) != null && !(currentUrl = this.getUrl()).equals(newUrl = helper.updatedUrl(currentUrl))) {
                super.setUrl(newUrl);
            }
            if (helper == null || !helper.enableUserDirHack()) {
                try {
                    super.createDataSource();
                }
                catch (Throwable e) {
                    throw BasicDataSource.toSQLException(e);
                }
            }
            Properties systemProperties = JavaSecurityManagers.getSystemProperties();
            String userDir = systemProperties.getProperty("user.dir");
            try {
                File base = SystemInstance.get().getBase().getDirectory();
                systemProperties.setProperty("user.dir", base.getAbsolutePath());
                try {
                    super.createDataSource();
                }
                catch (Throwable e) {
                    throw BasicDataSource.toSQLException(e);
                }
            }
            finally {
                systemProperties.setProperty("user.dir", userDir);
            }
            this.dsRef = (DataSource)DataSource.class.cast(Reflections.get(this, "dataSource"));
            return this.dsRef;
        }
    }

    public static SQLException toSQLException(Throwable e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        return new SQLException("Failed to create DataSource", e);
    }

    public synchronized void close() throws SQLException {
        try {
            this.unregisterMBean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
        this.dsRef = null;
        this.logger = null;
    }

    private void unregisterMBean() {
        if (this.jmxDs != null) {
            this.jmxDs.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            if (null == this.logger) {
                BasicDataSource basicDataSource = this;
                synchronized (basicDataSource) {
                    if (null == this.logger) {
                        this.logger = (Logger)Reflections.invokeByReflection(this.createDataSource(), "getParentLogger", new Class[0], null);
                    }
                }
            }
            return this.logger;
        }
        catch (Throwable e) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    public void setName(String name) {
        this.registerAsMbean(name);
        this.name = name;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        return name;
    }

    Object writeReplace() throws ObjectStreamException {
        return new DataSourceSerialization(this.name);
    }
}

