/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.AprStatus;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.LibraryNotFoundError;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class AprLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(AprLifecycleListener.class);
    private static final List<String> initInfoLogMessages = new ArrayList<String>(3);
    protected static final StringManager sm = StringManager.getManager(AprLifecycleListener.class);
    private static final int TCN_1_REQUIRED_MINOR = 3;
    private static final int TCN_1_REQUIRED_PATCH = 4;
    private static final int TCN_1_RECOMMENDED_MINOR = 3;
    private static final int TCN_1_RECOMMENDED_PATCH = 4;
    protected static final int TCN_REQUIRED_MAJOR = 2;
    protected static final int TCN_REQUIRED_MINOR = 0;
    protected static final int TCN_REQUIRED_PATCH = 12;
    protected static final int TCN_RECOMMENDED_MAJOR = 2;
    protected static final int TCN_RECOMMENDED_MINOR = 0;
    protected static final int TCN_RECOMMENDED_PV = 12;
    private static int tcnMajor = 0;
    private static int tcnMinor = 0;
    private static int tcnPatch = 0;
    private static int tcnVersion = 0;
    protected static String SSLEngine = "on";
    protected static String FIPSMode = "off";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean fipsModeActive = false;
    private static final int FIPS_ON = 1;
    private static final int FIPS_OFF = 0;
    private static int referenceCount = 0;
    private boolean instanceInitialized = false;

    public static boolean isAprAvailable() {
        if (AprStatus.isInstanceCreated()) {
            ReentrantReadWriteLock.WriteLock writeLock = AprStatus.getStatusLock().writeLock();
            writeLock.lock();
            try {
                AprLifecycleListener.init();
            }
            finally {
                writeLock.unlock();
            }
        }
        return AprStatus.isAprAvailable();
    }

    public AprLifecycleListener() {
        AprStatus.setInstanceCreated((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        block23: {
            if ("before_init".equals(event.getType())) {
                ReentrantReadWriteLock.WriteLock writeLock = AprStatus.getStatusLock().writeLock();
                writeLock.lock();
                try {
                    this.instanceInitialized = true;
                    if (!(event.getLifecycle() instanceof Server)) {
                        log.warn((Object)sm.getString("listener.notServer", new Object[]{event.getLifecycle().getClass().getSimpleName()}));
                    }
                    if (referenceCount++ != 0) {
                        return;
                    }
                    AprLifecycleListener.init();
                    for (String msg : initInfoLogMessages) {
                        log.info((Object)msg);
                    }
                    initInfoLogMessages.clear();
                    if (AprStatus.isAprAvailable()) {
                        try {
                            AprLifecycleListener.initializeSSL();
                        }
                        catch (Throwable t) {
                            Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                            ExceptionUtils.handleThrowable((Throwable)throwable);
                            log.error((Object)sm.getString("aprListener.sslInit"), throwable);
                        }
                    }
                    if (null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode) && !this.isFIPSModeActive()) {
                        Error e = new Error(sm.getString("aprListener.initializeFIPSFailed"));
                        log.fatal((Object)e.getMessage(), (Throwable)e);
                        throw e;
                    }
                    break block23;
                }
                finally {
                    writeLock.unlock();
                }
            }
            if ("after_destroy".equals(event.getType())) {
                ReentrantReadWriteLock.WriteLock writeLock = AprStatus.getStatusLock().writeLock();
                writeLock.lock();
                try {
                    if (this.instanceInitialized) {
                        --referenceCount;
                    }
                    if (referenceCount != 0) {
                        return;
                    }
                    if (!AprStatus.isAprAvailable()) {
                        return;
                    }
                    try {
                        AprLifecycleListener.terminateAPR();
                    }
                    catch (Throwable t) {
                        Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        log.warn((Object)sm.getString("aprListener.aprDestroy"), throwable);
                    }
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
    }

    private static void terminateAPR() {
        AprStatus.setAprInitialized((boolean)false);
        AprStatus.setAprAvailable((boolean)false);
        fipsModeActive = false;
        sslInitialized = false;
        System.gc();
        Library.terminate();
    }

    private static void init() {
        int rcver;
        int rqver;
        if (AprStatus.isAprInitialized()) {
            return;
        }
        AprStatus.setAprInitialized((boolean)true);
        try {
            Library.initialize(null);
            tcnMajor = Library.TCN_MAJOR_VERSION;
            tcnMinor = Library.TCN_MINOR_VERSION;
            tcnPatch = Library.TCN_PATCH_VERSION;
            tcnVersion = tcnMajor * 1000 + tcnMinor * 100 + tcnPatch;
        }
        catch (LibraryNotFoundError lnfe) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("aprListener.aprInitDebug", new Object[]{lnfe.getLibraryNames(), System.getProperty("java.library.path"), lnfe.getMessage()}), (Throwable)lnfe);
            }
            initInfoLogMessages.add(sm.getString("aprListener.aprInit", new Object[]{System.getProperty("java.library.path")}));
            return;
        }
        catch (Throwable t) {
            Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("aprListener.aprInitError", new Object[]{throwable.getMessage()}), throwable);
            return;
        }
        if (tcnMajor > 1 && "off".equalsIgnoreCase(SSLEngine)) {
            log.error((Object)sm.getString("aprListener.sslRequired", new Object[]{SSLEngine, Library.versionString()}));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable t) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                ExceptionUtils.handleThrowable((Throwable)throwable);
            }
            return;
        }
        if (tcnMajor == 1) {
            rqver = 1304;
            rcver = 1304;
        } else {
            rqver = 2012;
            rcver = 2012;
        }
        if (tcnVersion < rqver) {
            if (tcnMajor == 1) {
                log.error((Object)sm.getString("aprListener.tcnInvalid.1", new Object[]{Library.versionString(), "1.3.4"}));
            } else {
                log.error((Object)sm.getString("aprListener.tcnInvalid", new Object[]{Library.versionString(), "2.0.12"}));
            }
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable t) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                ExceptionUtils.handleThrowable((Throwable)throwable);
            }
            return;
        }
        if (tcnVersion < rcver) {
            if (tcnMajor == 1) {
                initInfoLogMessages.add(sm.getString("aprListener.tcnVersion.1", new Object[]{Library.versionString(), "1.3.4"}));
            } else {
                initInfoLogMessages.add(sm.getString("aprListener.tcnVersion", new Object[]{Library.versionString(), "2.0.12"}));
            }
        }
        initInfoLogMessages.add(sm.getString("aprListener.tcnValid", new Object[]{Library.versionString(), Library.aprVersionString()}));
        AprStatus.setAprAvailable((boolean)true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void initializeSSL() throws Exception {
        boolean usingProviders;
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        sslInitialized = true;
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        AprStatus.setOpenSSLVersion((int)SSL.version());
        boolean bl = usingProviders = tcnMajor > 1 || tcnVersion > 1233 && ((long)SSL.version() & 0xF0000000L) > 0x20000000L;
        if (usingProviders || null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode)) {
            boolean enterFipsMode;
            int fipsModeState;
            block25: {
                fipsModeActive = false;
                fipsModeState = SSL.fipsModeGet();
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("aprListener.currentFIPSMode", new Object[]{fipsModeState}));
                }
                if (null == FIPSMode || "off".equalsIgnoreCase(FIPSMode)) {
                    if (fipsModeState == 1) {
                        fipsModeActive = true;
                    }
                    enterFipsMode = false;
                } else if ("on".equalsIgnoreCase(FIPSMode)) {
                    if (fipsModeState == 1) {
                        if (!usingProviders) {
                            log.info((Object)sm.getString("aprListener.skipFIPSInitialization"));
                        }
                        fipsModeActive = true;
                        enterFipsMode = false;
                    } else {
                        if (usingProviders) {
                            throw new IllegalStateException(sm.getString("aprListener.FIPSProviderNotDefault", new Object[]{FIPSMode}));
                        }
                        enterFipsMode = true;
                    }
                } else {
                    if ("require".equalsIgnoreCase(FIPSMode)) {
                        if (fipsModeState == 1) {
                            fipsModeActive = true;
                            enterFipsMode = false;
                            break block25;
                        } else {
                            if (usingProviders) {
                                throw new IllegalStateException(sm.getString("aprListener.FIPSProviderNotDefault", new Object[]{FIPSMode}));
                            }
                            throw new IllegalStateException(sm.getString("aprListener.requireNotInFIPSMode"));
                        }
                    }
                    if (!"enter".equalsIgnoreCase(FIPSMode)) {
                        throw new IllegalArgumentException(sm.getString("aprListener.wrongFIPSMode", new Object[]{FIPSMode}));
                    }
                    if (fipsModeState == 0) {
                        if (usingProviders) {
                            throw new IllegalStateException(sm.getString("aprListener.FIPSProviderNotDefault", new Object[]{FIPSMode}));
                        }
                        enterFipsMode = true;
                    } else {
                        if (!usingProviders) {
                            throw new IllegalStateException(sm.getString("aprListener.enterAlreadyInFIPSMode", new Object[]{fipsModeState}));
                        }
                        fipsModeActive = true;
                        enterFipsMode = false;
                    }
                }
            }
            if (enterFipsMode) {
                log.info((Object)sm.getString("aprListener.initializingFIPS"));
                fipsModeState = SSL.fipsModeSet((int)1);
                if (fipsModeState != 1) {
                    String message = sm.getString("aprListener.initializeFIPSFailed");
                    log.error((Object)message);
                    throw new IllegalStateException(message);
                }
                fipsModeActive = true;
                log.info((Object)sm.getString("aprListener.initializeFIPSSuccess"));
            }
            if (usingProviders && fipsModeActive) {
                log.info((Object)sm.getString("aprListener.usingFIPSProvider"));
            }
        }
        log.info((Object)sm.getString("aprListener.initializedOpenSSL", new Object[]{SSL.versionString()}));
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine) {
        if (!SSLEngine.equals(AprLifecycleListener.SSLEngine)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLEngine"));
            }
            AprLifecycleListener.SSLEngine = SSLEngine;
        }
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        if (!SSLRandomSeed.equals(AprLifecycleListener.SSLRandomSeed)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLRandomSeed"));
            }
            AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
        }
    }

    public String getFIPSMode() {
        return FIPSMode;
    }

    public void setFIPSMode(String FIPSMode) {
        if (!FIPSMode.equals(AprLifecycleListener.FIPSMode)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForFIPSMode"));
            }
            AprLifecycleListener.FIPSMode = FIPSMode;
        }
    }

    public boolean isFIPSModeActive() {
        return fipsModeActive;
    }

    public void setUseOpenSSL(boolean useOpenSSL) {
        if (useOpenSSL != AprStatus.getUseOpenSSL()) {
            AprStatus.setUseOpenSSL((boolean)useOpenSSL);
        }
    }

    public static boolean getUseOpenSSL() {
        return AprStatus.getUseOpenSSL();
    }

    public static boolean isInstanceCreated() {
        return AprStatus.isInstanceCreated();
    }
}

