/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.json.gson;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new DateTypeAdapter() : null;
        }
    };
    private DateFormat customDateFormat = DateFormat.getDateTimeInstance(2, 2);

    public void setCustomDateFormat(DateFormat df) {
        this.customDateFormat = df;
    }

    public DateFormat getCustomDateFormat() {
        return this.customDateFormat;
    }

    public Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return this.deserializeToDate(in.nextString());
    }

    private synchronized Date deserializeToDate(String json) {
        try {
            return this.customDateFormat.parse(json);
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(json, (Throwable)e);
        }
    }

    public synchronized void write(JsonWriter out, Date value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        String dateFormatAsString = this.customDateFormat.format(value);
        out.value(dateFormatAsString);
    }
}

