/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory;

import java.util.ArrayList;
import java.util.List;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.memory.MemoryHelper;
import org.apache.fulcrum.security.spi.AbstractGroupManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class MemoryGroupManagerImpl
extends AbstractGroupManager
implements GroupManager {
    private static List<Group> groups = new ArrayList<Group>();

    public MemoryGroupManagerImpl() {
        groups = new ArrayList<Group>();
    }

    public GroupSet getAllGroups() throws DataBackendException {
        return new GroupSet(groups);
    }

    public synchronized void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            groupExists = this.checkExists(group);
            if (groupExists) {
                groups.remove(group);
                return;
            }
            throw new UnknownEntityException("Unknown group '" + String.valueOf(group) + "'");
        }
        catch (Exception e) {
            this.getLogger().error("Failed to delete a Group", (Throwable)e);
            throw new DataBackendException("removeGroup(Group) failed", (Throwable)e);
        }
    }

    public synchronized void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            groupExists = this.checkExists(group);
            if (!groupExists) {
                throw new UnknownEntityException("Unknown group '" + String.valueOf(group) + "'");
            }
            groups.remove(group);
            group.setName(name);
            groups.add(group);
        }
        catch (Exception e) {
            throw new DataBackendException("renameGroup(Group,String)", (Throwable)e);
        }
    }

    public boolean checkExists(String groupName) throws DataBackendException {
        return MemoryHelper.checkExists(groups, groupName);
    }

    protected synchronized <T extends Group> T persistNewGroup(T group) throws DataBackendException {
        group.setId((Object)MemoryHelper.getUniqueId());
        groups.add(group);
        return group;
    }
}

