/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory;

import java.util.ArrayList;
import java.util.List;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.memory.MemoryHelper;
import org.apache.fulcrum.security.spi.AbstractPermissionManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class MemoryPermissionManagerImpl
extends AbstractPermissionManager {
    private static List<Permission> permissions = new ArrayList<Permission>();

    public MemoryPermissionManagerImpl() {
        permissions.clear();
    }

    public PermissionSet getAllPermissions() throws DataBackendException {
        return new PermissionSet(permissions);
    }

    public synchronized void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            permissionExists = this.checkExists(permission);
            if (permissionExists) {
                permissions.remove(permission);
                permission.setName(name);
                permissions.add(permission);
                return;
            }
        }
        catch (DataBackendException e) {
            throw new DataBackendException("renamePermission(Permission,name)", (Throwable)e);
        }
        throw new UnknownEntityException("Unknown permission '" + String.valueOf(permission) + "'");
    }

    public boolean checkExists(String permissionName) throws DataBackendException {
        return MemoryHelper.checkExists(permissions, permissionName);
    }

    public synchronized void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            permissionExists = this.checkExists(permission);
            if (permissionExists) {
                permissions.remove(permission);
                return;
            }
        }
        catch (DataBackendException e) {
            throw new DataBackendException("removePermission(Permission)", (Throwable)e);
        }
        throw new UnknownEntityException("Unknown permission '" + String.valueOf(permission) + "'");
    }

    protected synchronized <T extends Permission> T persistNewPermission(T permission) throws DataBackendException {
        permission.setId((Object)MemoryHelper.getUniqueId());
        permissions.add(permission);
        return permission;
    }
}

