/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.ide.ui.text.RutaPartitionScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class RutaAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    IPreferenceStore fStore;
    String fPartitioning;
    final int maxCharsAway = 100;

    public RutaAutoEditStrategy(IPreferenceStore store, String part) {
        this.fStore = store;
        this.fPartitioning = part;
    }

    private boolean isSmartTab() {
        return this.fStore.getBoolean("smart_tab");
    }

    private boolean isSmartMode() {
        return this.fStore.getBoolean("editorSmartIndent");
    }

    private boolean closeBrackets() {
        return this.fStore.getBoolean("closeBrackets");
    }

    private boolean isSmartPaste() {
        return this.fStore.getBoolean("smartPaste");
    }

    private boolean closeStrings() {
        return this.fStore.getBoolean("closeStrings");
    }

    private int getIndentSize() {
        return this.fStore.getInt("formatter.indentation.size");
    }

    private String getTabStyle() {
        return this.fStore.getString("formatter.tabulation.char");
    }

    private String getIndent() {
        if (this.getTabStyle().equals("space")) {
            int size = this.getIndentSize();
            String res = "";
            for (int i = 0; i < size; ++i) {
                res = res + " ";
            }
            return res;
        }
        return "\t";
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private String getLineIndent(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    public String getLineIndent(String line) {
        int end;
        int whiteend = end = line.length();
        for (int offset = 0; offset < end; ++offset) {
            char c = line.charAt(offset);
            if (c == ' ' || c == '\t') continue;
            whiteend = offset;
            break;
        }
        return line.substring(0, whiteend);
    }

    private int getLastNonEmptyLine(IDocument d, int line) throws BadLocationException {
        int res;
        for (res = line; res > -1; --res) {
            String str = this.getDocumentLine(d, res).trim();
            if (str.startsWith("#") || str.length() <= 0) continue;
            return res;
        }
        return res;
    }

    public String getDocumentLine(IDocument d, int line) throws BadLocationException {
        int start = d.getLineOffset(line);
        int length = d.getLineLength(line);
        return d.get(start, length);
    }

    private String getRegionType(IDocument d, int offset) throws BadLocationException {
        int p = offset == d.getLength() ? offset - 1 : offset;
        ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)p, (boolean)true);
        return region.getType();
    }

    private int searchPair(IDocument d, int offset, boolean forward, char opening, char closing, boolean skipCommentLines, boolean skipStrings) throws BadLocationException {
        int deep = 0;
        int i = offset;
        if (forward) {
            while (i < d.getLength()) {
                ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)i, (boolean)true);
                if (region.getType() == "__ruta_comment" && skipCommentLines) {
                    i = region.getOffset() + region.getLength();
                    continue;
                }
                if (region.getType() == "__ruta_string" && skipStrings) {
                    i = region.getOffset() + region.getLength();
                    continue;
                }
                char c = d.getChar(i);
                if (c == opening) {
                    ++deep;
                }
                if (c == closing) {
                    if (deep == 0) {
                        return i;
                    }
                    --deep;
                }
                if (++i - offset <= 100) continue;
                return -1;
            }
        } else {
            while (i >= 0) {
                ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)i, (boolean)true);
                if (region.getType() == "__ruta_comment" && skipCommentLines) {
                    i = region.getOffset() - 1;
                    continue;
                }
                if (region.getType() == "__ruta_string" && skipStrings) {
                    i = region.getOffset() - 1;
                    continue;
                }
                char c = d.getChar(i);
                if (c == closing) {
                    ++deep;
                }
                if (c == opening) {
                    if (deep == 0) {
                        return i;
                    }
                    --deep;
                }
                if (offset - --i <= 100) continue;
                return -1;
            }
        }
        return -1;
    }

    private int findIndentStart(IDocument d, int line) throws BadLocationException {
        String curIndent = this.getLineIndent(d, line);
        int curIndentLength = this.getPhysicalLength(curIndent);
        for (int cur = line - 1; cur >= 0; --cur) {
            String curLine = this.getDocumentLine(d, cur);
            String ind = this.getLineIndent(d, cur);
            if (curLine.trim().startsWith("#") || this.getPhysicalLength(ind) >= curIndentLength) continue;
            return cur;
        }
        return line;
    }

    public int getPhysicalLength(String str) {
        int res = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\t') {
                res += 8;
                continue;
            }
            ++res;
        }
        return res;
    }

    private char getBracePair(char b) {
        switch (b) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return b;
    }

    private static void installStuff(Document document) {
        String[] types = new String[]{"__ruta_string", "__ruta_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new RutaPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__ruta_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeStuff(Document document) {
        document.setDocumentPartitioner("__ruta_partitioning", null);
    }

    private String calcLineIndent(IDocument d, int line, boolean newLine, int offset) throws BadLocationException {
        int plnumstart;
        int lastNonEmptyLine;
        String previousLine;
        int realLine;
        boolean isDocumentEnd;
        boolean bl = isDocumentEnd = offset == d.getLength();
        if (newLine) {
            if (this.getRegionType(d, offset) == "__ruta_string") {
                realLine = d.getLineOfOffset(offset);
                String curIndent = this.getLineIndent(d, realLine);
                if (d.getChar(offset - 1) != '\"') {
                    if (this.getRegionType(d, d.getLineOffset(realLine)) == "__ruta_string") {
                        return curIndent;
                    }
                    return curIndent + this.getIndent();
                }
            }
        } else if (this.getRegionType(d, d.getLineOffset(line)) == "__ruta_string") {
            return this.getLineIndent(d, line);
        }
        if (newLine) {
            realLine = d.getLineOfOffset(offset);
            if (line > 0) {
                String prePreviousLine;
                String previousLine2 = "";
                if (realLine == line - 1) {
                    int start = d.getLineOffset(realLine);
                    previousLine2 = d.get(start, offset - start);
                } else {
                    previousLine2 = this.getDocumentLine(d, line - 1);
                }
                if (previousLine2.trim().endsWith("\\")) {
                    String prePreviousLine2 = this.getDocumentLine(d, line - 2);
                    if (prePreviousLine2.trim().endsWith("\\")) {
                        return this.getLineIndent(d, line - 1);
                    }
                    return this.getLineIndent(d, line - 1) + this.getIndent() + this.getIndent();
                }
                if (line > 1 && (prePreviousLine = this.getDocumentLine(d, line - 2)).trim().endsWith("\\")) {
                    int t;
                    for (t = line - 2; t > 0 && this.getDocumentLine(d, t - 1).trim().endsWith("\\"); --t) {
                    }
                    return this.getLineIndent(d, t);
                }
            }
        } else if (line > 0 && (previousLine = this.getDocumentLine(d, line - 1)).trim().endsWith("\\")) {
            String prePreviousLine;
            if (line > 1 && (prePreviousLine = this.getDocumentLine(d, line - 2)).trim().endsWith("\\")) {
                return this.getLineIndent(d, line - 1);
            }
            return this.getLineIndent(d, line - 1) + this.getIndent() + this.getIndent();
        }
        if ((lastNonEmptyLine = this.getLastNonEmptyLine(d, line - 1)) < 0) {
            return "";
        }
        ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)d.getLineOffset(lastNonEmptyLine), (boolean)true);
        if (region.getType() == "__ruta_string") {
            lastNonEmptyLine = d.getLineOfOffset(region.getOffset());
        }
        String previousLineIndent = "";
        int pairOffset = this.searchPair(d, d.getLineOffset(lastNonEmptyLine), false, '(', ')', true, true);
        if (pairOffset >= 0) {
            plnumstart = d.getLineOfOffset(pairOffset);
            previousLineIndent = this.getLineIndent(d, plnumstart);
        } else {
            plnumstart = lastNonEmptyLine;
            previousLineIndent = this.getLineIndent(d, lastNonEmptyLine);
        }
        int p = this.searchPair(d, offset - 1, false, '(', ')', true, true);
        if (p >= 0) {
            if (d.getLineOfOffset(p) == lastNonEmptyLine) {
                int pp = this.searchPair(d, p, false, '(', ')', true, true);
                if (pp >= 0) {
                    return this.getLineIndent(d, lastNonEmptyLine) + this.getIndent();
                }
                return this.getLineIndent(d, lastNonEmptyLine) + this.getIndent() + this.getIndent();
            }
            if (d.getLineOfOffset(p) == plnumstart) {
                return this.getLineIndent(d, lastNonEmptyLine);
            }
            if (d.getLineOfOffset(p) == line && !newLine) {
                return null;
            }
            return previousLineIndent;
        }
        String pline = "";
        pline = lastNonEmptyLine == line - 1 && newLine ? d.get(d.getLineOffset(line - 1), offset - d.getLineOffset(line - 1)) : this.getDocumentLine(d, lastNonEmptyLine);
        int plineLen = pline.length();
        for (int i = 0; i < plineLen; ++i) {
            if (pline.charAt(i) != '#') continue;
            pline = pline.substring(0, i);
            break;
        }
        String plineTrimmed = pline.trim();
        try {
            String curLine = "";
            curLine = lastNonEmptyLine == line - 1 && newLine ? d.get(offset, d.getLineLength(line - 1) + d.getLineOffset(line - 1) - offset) : this.getDocumentLine(d, line).trim();
            if (curLine.startsWith("except") || curLine.startsWith("finally")) {
                for (int lnum = line - 1; lnum >= 0; --lnum) {
                    String temp = this.getDocumentLine(d, lnum).trim();
                    if (!temp.startsWith("try") && !temp.startsWith("except")) continue;
                    String ind = this.getLineIndent(d, lnum);
                    return ind;
                }
                return null;
            }
            if (curLine.startsWith("elif") || curLine.startsWith("else")) {
                String temp = this.getDocumentLine(d, lastNonEmptyLine).trim();
                if (temp.startsWith("for") || temp.startsWith("if") || temp.startsWith("try") || temp.startsWith("while")) {
                    return previousLineIndent;
                }
                int sline = this.findIndentStart(d, lastNonEmptyLine);
                String reqIndent = this.getLineIndent(d, sline);
                return reqIndent;
            }
        }
        catch (BadLocationException curLine) {
            // empty catch block
        }
        String regex = "^\\s*(break|continue|raise|pass|return)(\\s+.*$|$)";
        if (Pattern.matches(regex, plineTrimmed)) {
            int sline = this.findIndentStart(d, lastNonEmptyLine);
            String reqIndent = this.getLineIndent(d, sline);
            if (newLine || isDocumentEnd || this.getPhysicalLength(this.getLineIndent(d, line)) > this.getPhysicalLength(reqIndent)) {
                return reqIndent;
            }
            return null;
        }
        if (plineTrimmed.endsWith(":")) {
            return previousLineIndent + this.getIndent();
        }
        if (pairOffset >= 0 && newLine) {
            return previousLineIndent;
        }
        int prevLine = this.getLastNonEmptyLine(d, line - 1);
        if (this.getRegionType(d, d.getLineOffset(prevLine)) == "__ruta_string") {
            return previousLineIndent;
        }
        return null;
    }

    private void reindent(IDocument d, DocumentCommand c) {
        try {
            if (this.getRegionType(d, c.offset) != "__dftl_partition_content_type") {
                return;
            }
            int line = d.getLineOfOffset(c.offset);
            String newIndent = this.calcLineIndent(d, line, false, c.offset);
            if (newIndent == null) {
                return;
            }
            String curIndent = this.getLineIndent(d, line);
            if (this.getPhysicalLength(curIndent) < this.getPhysicalLength(newIndent)) {
                return;
            }
            d.replace(d.getLineOffset(line), curIndent.length(), newIndent);
            c.offset += newIndent.length() - curIndent.length();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void autoClose(IDocument d, DocumentCommand c) {
        if (c.offset == -1) {
            return;
        }
        try {
            if (d.getChar(c.offset - 1) == '\\') {
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if ('\"' == c.text.charAt(0) && !this.closeStrings()) {
            return;
        }
        if ('\'' == c.text.charAt(0) && !this.closeStrings()) {
            return;
        }
        if (!(this.closeBrackets() || '[' != c.text.charAt(0) && '(' != c.text.charAt(0) && '{' != c.text.charAt(0))) {
            return;
        }
        try {
            switch (c.text.charAt(0)) {
                case '\"': 
                case '\'': {
                    if ('\"' == c.text.charAt(0) && c.offset > 0 && "\"".equals(d.get(c.offset - 1, 1))) {
                        return;
                    }
                    if ('\'' == c.text.charAt(0) && c.offset > 0 && "'".equals(d.get(c.offset - 1, 1))) {
                        return;
                    }
                    if (c.offset != d.getLength() && c.text.charAt(0) == d.get(c.offset, 1).charAt(0)) {
                        c.text = "";
                    } else {
                        c.text = c.text + c.text;
                        c.length = 0;
                    }
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + 1;
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    if (this.getRegionType(d, c.offset) != "__dftl_partition_content_type") {
                        return;
                    }
                    if (c.offset != d.getLength() && c.text.charAt(0) == d.get(c.offset, 1).charAt(0)) {
                        return;
                    }
                    try {
                        String regex = "^\\s*class\\s+.*";
                        String regex2 = ".*\\(.*\\).*";
                        int start = d.getLineOffset(d.getLineOfOffset(c.offset));
                        String curLine = d.get(start, c.offset - start);
                        if (Pattern.matches(regex, curLine) && !Pattern.matches(regex2, curLine)) {
                            c.text = "():";
                            c.shiftsCaret = false;
                            c.caretOffset = c.offset + 1;
                            return;
                        }
                    }
                    catch (BadLocationException regex) {
                        // empty catch block
                    }
                    c.text = c.text + this.getBracePair(c.text.charAt(0));
                    c.length = 0;
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + 1;
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (this.getRegionType(d, c.offset) != "__dftl_partition_content_type") {
                        return;
                    }
                    if (!this.closeBrackets()) {
                        return;
                    }
                    if (c.offset == d.getLength() || c.text.charAt(0) != d.get(c.offset, 1).charAt(0)) break;
                    c.text = "";
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + 1;
                    return;
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean smartIndentJump(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return false;
        }
        try {
            int line = d.getLineOfOffset(c.offset);
            int start = d.getLineOffset(line);
            String resultIndent = this.calcLineIndent(d, line, false, start);
            String currentIndent = this.getLineIndent(d, line);
            if (resultIndent == null) {
                String curLine = this.getDocumentLine(d, line);
                if (curLine.trim().length() > 0) {
                    resultIndent = currentIndent;
                } else {
                    int pl = this.getLastNonEmptyLine(d, line - 1);
                    if (pl >= 0) {
                        String plStr = this.getDocumentLine(d, pl).trim();
                        String regex = "^\\s*(break|continue|raise|pass|return)(\\s+.*$|$)";
                        if (plStr.endsWith(":")) {
                            resultIndent = this.getLineIndent(plStr) + this.getIndent();
                        } else if (Pattern.matches(regex, plStr)) {
                            int sline = this.findIndentStart(d, pl);
                            resultIndent = this.getLineIndent(d, sline);
                        } else {
                            resultIndent = this.getLineIndent(d, pl);
                        }
                    } else {
                        return false;
                    }
                }
            }
            if (c.offset >= start + resultIndent.length()) {
                return false;
            }
            if (!currentIndent.startsWith(resultIndent)) {
                c.offset = start;
                c.length = currentIndent.length();
                c.shiftsCaret = false;
                c.text = resultIndent;
                c.caretOffset = d.getLineOffset(line) + resultIndent.length();
                return true;
            }
            c.length = 0;
            c.shiftsCaret = false;
            c.text = "";
            c.caretOffset = d.getLineOffset(line) + resultIndent.length();
            return true;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void smartPaste(IDocument d, DocumentCommand c) {
        try {
            String content = d.get(0, c.offset) + c.text;
            Document temp = new Document(content);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            RutaAutoEditStrategy.installStuff(temp);
            int offset = c.offset;
            int line = temp.getLineOfOffset(offset);
            String lastIndent = this.getLineIndent((IDocument)temp, line);
            int firstLineOffset = temp.getLineOffset(line);
            String commonIndent = temp.get(firstLineOffset, c.offset - firstLineOffset);
            if (StringUtils.isNotBlank((CharSequence)commonIndent)) {
                String notWSContent = commonIndent.replaceAll("^\\s+", "");
                commonIndent = StringUtils.removeEnd((String)commonIndent, (String)notWSContent);
            }
            ++line;
            try {
                while (this.getDocumentLine((IDocument)temp, line).trim().length() == 0) {
                    ++line;
                }
                offset = temp.getLineOffset(line);
            }
            catch (BadLocationException e) {
                offset = temp.getLength();
            }
            while (offset < temp.getLength()) {
                String resultIndent = this.calcLineIndent((IDocument)temp, line, false, temp.getLineOffset(line));
                String currentIndent = this.getLineIndent((IDocument)temp, line);
                if (resultIndent == null) {
                    resultIndent = commonIndent + currentIndent;
                }
                temp.replace(offset, currentIndent.length(), resultIndent);
                String currentLine = this.getDocumentLine((IDocument)temp, line);
                if (currentLine.trim().length() > 0 && !currentLine.trim().startsWith("//")) {
                    lastIndent = resultIndent;
                }
                if (temp.getLineOffset(line) + temp.getLineLength(line) == temp.getLength()) break;
                offset = temp.getLineOffset(++line);
            }
            temp.stopRewriteSession(session);
            RutaAutoEditStrategy.removeStuff(temp);
            c.text = temp.get(c.offset, temp.getLength() - c.offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            if (!this.isSmartMode()) {
                super.customizeDocumentCommand(d, c);
                return;
            }
            try {
                String indent = this.calcLineIndent(d, d.getLineOfOffset(c.offset) + 1, true, c.offset);
                if (indent == null) {
                    super.customizeDocumentCommand(d, c);
                } else {
                    c.text = c.text + indent;
                }
            }
            catch (BadLocationException e) {
                super.customizeDocumentCommand(d, c);
            }
            return;
        }
        if (c.length <= 1 && c.text.length() == 1) {
            switch (c.text.charAt(0)) {
                case ':': {
                    this.reindent(d, c);
                    break;
                }
                case '\"': 
                case '\'': 
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    this.autoClose(d, c);
                    break;
                }
                case '\t': {
                    boolean jumped = false;
                    if (this.isSmartTab()) {
                        jumped = this.smartIndentJump(d, c);
                    }
                    if (jumped) break;
                    c.text = this.getIndent();
                }
            }
        } else if (c.text.length() >= 1 && this.isSmartPaste()) {
            this.smartPaste(d, c);
        }
    }
}

