/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.utils;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.apache.uima.ruta.cde.utils.ConstraintData;
import org.apache.uima.ruta.cde.utils.DocumentData;
import org.eclipse.swt.widgets.TableColumn;

public class CDEComparatorFactory {
    private int updown = 1;
    private Comparator<DocumentData> stringDocumentComparator = new Comparator<DocumentData>(){

        @Override
        public int compare(DocumentData object1, DocumentData object2) {
            Collator collator = Collator.getInstance();
            String docName1 = object1.getDocument().getName();
            String docName2 = object2.getDocument().getName();
            int result = collator.compare(docName1, docName2) * CDEComparatorFactory.this.updown;
            return result;
        }
    };
    private Comparator<DocumentData> resultComparator = new Comparator<DocumentData>(){

        @Override
        public int compare(DocumentData object1, DocumentData object2) {
            double augment2;
            double augment1 = object1.getAugmentedResult();
            if (augment1 < (augment2 = object2.getAugmentedResult())) {
                return 1 * CDEComparatorFactory.this.updown;
            }
            if (augment1 > augment2) {
                return -1 * CDEComparatorFactory.this.updown;
            }
            return 0;
        }
    };
    private Comparator<DocumentData> f1ScoreComparator = new Comparator<DocumentData>(){

        @Override
        public int compare(DocumentData object1, DocumentData object2) {
            double augment2;
            double augment1 = object1.getFMeasure();
            if (augment1 < (augment2 = object2.getFMeasure())) {
                return 1 * CDEComparatorFactory.this.updown;
            }
            if (augment1 > augment2) {
                return -1 * CDEComparatorFactory.this.updown;
            }
            return 0;
        }
    };
    private Comparator<ConstraintData> stringConstraintComparator = new Comparator<ConstraintData>(){

        @Override
        public int compare(ConstraintData object1, ConstraintData object2) {
            Collator collator = Collator.getInstance();
            String constraintName1 = object1.getDescription();
            String constraintName2 = object2.getDescription();
            int result = collator.compare(constraintName1, constraintName2) * CDEComparatorFactory.this.updown;
            return result;
        }
    };
    private Comparator<ConstraintData> intConstraintComparator = new Comparator<ConstraintData>(){

        @Override
        public int compare(ConstraintData object1, ConstraintData object2) {
            int weight1 = object1.getWeight();
            int weight2 = object2.getWeight();
            return (weight1 - weight2) * CDEComparatorFactory.this.updown;
        }
    };
    private Comparator<String[]> resultNameComparator = new Comparator<String[]>(){

        @Override
        public int compare(String[] object1, String[] object2) {
            Collator collator = Collator.getInstance(Locale.getDefault());
            int result = collator.compare(object1[0], object2[0]) * CDEComparatorFactory.this.updown;
            return result;
        }
    };
    private Comparator<String[]> resultValueComparator = new Comparator<String[]>(){

        @Override
        public int compare(String[] object1, String[] object2) {
            double result2;
            double result1 = Double.valueOf(object1[1]);
            if (result1 > (result2 = Double.valueOf(object2[1]).doubleValue())) {
                return 1 * CDEComparatorFactory.this.updown;
            }
            if (result1 > result2) {
                return -1 * CDEComparatorFactory.this.updown;
            }
            return 0;
        }
    };

    public Comparator getComparator(TableColumn tc) {
        this.updown *= -1;
        String columnName = tc.getText();
        if (columnName.equals("CDE")) {
            return this.resultComparator;
        }
        if (columnName.equals("F1")) {
            return this.f1ScoreComparator;
        }
        if (columnName.equals("Document")) {
            return this.stringDocumentComparator;
        }
        if (columnName.equals("Constraint")) {
            return this.stringConstraintComparator;
        }
        if (columnName.equals("Weight")) {
            return this.intConstraintComparator;
        }
        if (columnName.equals("Constraint ")) {
            return this.resultNameComparator;
        }
        if (columnName.equals("Result")) {
            return this.resultValueComparator;
        }
        return Collator.getInstance();
    }
}

