/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.searchStrategy;

import java.util.List;
import org.apache.uima.caseditor.ide.searchstrategy.ITypeSystemSearchStrategy;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.core.RutaNature;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class TestingSearchStrategy
implements ITypeSystemSearchStrategy {
    public IFile findTypeSystem(IFile casFile) {
        IPath location = casFile.getLocation();
        IProject project = casFile.getProject();
        try {
            IProjectNature nature = project.getNature("org.apache.uima.ruta.ide.nature");
            if (!(nature instanceof RutaNature)) {
                return null;
            }
        }
        catch (CoreException e) {
            return null;
        }
        IFolder testFolder = project.getFolder(RutaProjectUtils.getDefaultTestLocation());
        IPath relativeTo = location.makeRelativeTo(testFolder.getLocation());
        IPath segments = relativeTo.removeLastSegments(2);
        String scriptName = segments.lastSegment();
        if (scriptName == null) {
            return null;
        }
        segments = segments.removeLastSegments(1);
        Object tsName = "";
        try {
            tsName = scriptName + RutaProjectUtils.getTypeSystemSuffix((IProject)project) + ".xml";
        }
        catch (Exception e) {
            return null;
        }
        List descriptorFolders = null;
        try {
            descriptorFolders = RutaProjectUtils.getDescriptorFolders((IProject)project);
        }
        catch (CoreException e) {
            RutaAddonsPlugin.error(e);
        }
        if (descriptorFolders == null) {
            return null;
        }
        for (IFolder iFolder : descriptorFolders) {
            IFile result = iFolder.getFile((String)tsName);
            if (result != null && result.exists()) continue;
            return null;
        }
        return null;
    }
}

