/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jms.error.handler;

import java.net.ConnectException;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InProcessCache;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.ErrorHandler;
import org.apache.uima.aae.error.ErrorHandlerBase;
import org.apache.uima.util.Level;

public class JMSExceptionHandler
extends ErrorHandlerBase
implements ErrorHandler {
    private static final Class CLASS_NAME = JMSExceptionHandler.class;

    public boolean handleError(Throwable t, ErrorContext anErrorContext, AnalysisEngineController aController) {
        if (t instanceof JMSException) {
            Throwable cause = t.getCause();
            boolean handled = false;
            if (cause != null && cause instanceof ConnectException) {
                this.handleConnectError((ConnectException)cause, anErrorContext, aController);
                handled = true;
            }
            if (!handled && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_exception__WARNING", t);
            }
            return true;
        }
        return t instanceof IllegalArgumentException && t.getCause() != null && t.getCause() instanceof URISyntaxException;
    }

    private void handleConnectError(ConnectException exception, ErrorContext anErrorContext, AnalysisEngineController aController) {
        String casReferenceId = (String)anErrorContext.get("CasReference");
        Endpoint endpoint = (Endpoint)anErrorContext.get("Endpoint");
        if (!(aController instanceof AggregateAnalysisEngineController)) {
            InProcessCache.CacheEntry entry = null;
            try {
                entry = aController.getInProcessCache().getCacheEntryForCAS(casReferenceId);
                if (endpoint.isRemote() && entry != null) {
                    aController.dropCAS(casReferenceId, true);
                }
            }
            catch (AsynchAEException asynchAEException) {
                // empty catch block
            }
        }
    }
}

