/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.internal.util.Int2IntHashMap;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;

public class XmiSerializationSharedData {
    private Int2IntHashMap fsAddrToXmiIdMap = new Int2IntHashMap();
    private Int2IntHashMap xmiIdToFsAddrMap = new Int2IntHashMap();
    private List<OotsElementData> ootsFs = new ArrayList<OotsElementData>();
    private Map<String, List<String>> ootsViewMembers = new HashMap<String, List<String>>();
    private Map<Integer, OotsElementData> ootsFeatures = new HashMap<Integer, OotsElementData>();
    private Map<Integer, List<XmiArrayElement>> ootsArrayElements = new HashMap<Integer, List<XmiArrayElement>>();
    private int maxXmiId = 0;
    Int2IntHashMap nonsharedfeatureIdToFSId = new Int2IntHashMap();

    void addIdMapping(int fsAddr, int xmiId) {
        this.fsAddrToXmiIdMap.put(fsAddr, xmiId);
        this.xmiIdToFsAddrMap.put(xmiId, fsAddr);
        if (xmiId > this.maxXmiId) {
            this.maxXmiId = xmiId;
        }
    }

    String getXmiId(int fsAddr) {
        return Integer.toString(this.getXmiIdAsInt(fsAddr));
    }

    int getXmiIdAsInt(int fsAddr) {
        int xmiId = this.fsAddrToXmiIdMap.get(fsAddr);
        if (xmiId == 0) {
            xmiId = ++this.maxXmiId;
            this.addIdMapping(fsAddr, xmiId);
        }
        return xmiId;
    }

    public int getMaxXmiId() {
        return this.maxXmiId;
    }

    public int getFsAddrForXmiId(int xmiId) {
        int addr = this.xmiIdToFsAddrMap.get(xmiId);
        return addr == 0 ? -1 : addr;
    }

    public void clearIdMap() {
        this.fsAddrToXmiIdMap.clear();
        this.xmiIdToFsAddrMap.clear();
        this.nonsharedfeatureIdToFSId.clear();
        this.maxXmiId = 0;
    }

    public void addOutOfTypeSystemElement(OotsElementData elemData) {
        this.ootsFs.add(elemData);
        int xmiId = Integer.parseInt(elemData.xmiId);
        if (xmiId > this.maxXmiId) {
            this.maxXmiId = xmiId;
        }
    }

    public List<OotsElementData> getOutOfTypeSystemElements() {
        return Collections.unmodifiableList(this.ootsFs);
    }

    public void addOutOfTypeSystemViewMember(String sofaXmiId, String memberXmiId) {
        List<String> membersList = this.ootsViewMembers.get(sofaXmiId);
        if (membersList == null) {
            membersList = new ArrayList<String>();
            this.ootsViewMembers.put(sofaXmiId, membersList);
        }
        membersList.add(memberXmiId);
    }

    public List<String> getOutOfTypeSystemViewMembers(String sofaXmiId) {
        List<String> members = this.ootsViewMembers.get(sofaXmiId);
        return members == null ? null : Collections.unmodifiableList(members);
    }

    public void addOutOfTypeSystemAttribute(int addr, String featName, String featVal) {
        Integer key = addr;
        OotsElementData oed = this.ootsFeatures.get(key);
        if (oed == null) {
            oed = new OotsElementData();
            this.ootsFeatures.put(key, oed);
        }
        oed.attributes.add(new XmlAttribute(featName, featVal));
    }

    public void addOutOfTypeSystemChildElements(int addr, String featName, List<String> featVals) {
        Integer key = addr;
        OotsElementData oed = this.ootsFeatures.get(key);
        if (oed == null) {
            oed = new OotsElementData();
            this.ootsFeatures.put(key, oed);
        }
        Iterator<String> iter = featVals.iterator();
        XmlElementName elemName = new XmlElementName("", featName, featName);
        while (iter.hasNext()) {
            oed.childElements.add(new XmlElementNameAndContents(elemName, iter.next()));
        }
    }

    public OotsElementData getOutOfTypeSystemFeatures(int addr) {
        Integer key = addr;
        return this.ootsFeatures.get(key);
    }

    public int[] getAllFsAddressesInIdMap() {
        return this.fsAddrToXmiIdMap.getSortedKeys();
    }

    public List<XmiArrayElement> getOutOfTypeSystemArrayElements(int addr) {
        return this.ootsArrayElements.get(addr);
    }

    public boolean hasOutOfTypeSystemArrayElements() {
        return this.ootsArrayElements != null && this.ootsArrayElements.size() > 0;
    }

    public void addOutOfTypeSystemArrayElement(int addr, int index, int xmiId) {
        Integer key = addr;
        List<XmiArrayElement> list = this.ootsArrayElements.get(key);
        if (list == null) {
            list = new ArrayList<XmiArrayElement>();
            this.ootsArrayElements.put(key, list);
        }
        list.add(new XmiArrayElement(index, Integer.toString(xmiId)));
    }

    public void addNonsharedRefToFSMapping(int nonsharedFSAddr, int fsAddr) {
        this.nonsharedfeatureIdToFSId.put(nonsharedFSAddr, fsAddr);
    }

    public int[] getNonsharedMulitValuedFSs() {
        return this.nonsharedfeatureIdToFSId.getSortedKeys();
    }

    public int getEncompassingFS(int nonsharedFS) {
        int addr = this.nonsharedfeatureIdToFSId.get(nonsharedFS);
        return addr == 0 ? -1 : addr;
    }

    void checkForDups() {
        BitSet ids = new BitSet();
        IntListIterator iter = this.fsAddrToXmiIdMap.keyIterator();
        while (iter.hasNext()) {
            int xmiId = iter.next();
            if (ids.get(xmiId)) {
                throw new RuntimeException("Duplicate ID " + xmiId + "!");
            }
            ids.set(xmiId);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int[] keys = this.fsAddrToXmiIdMap.getSortedKeys();
        for (int i = 0; i < keys.length; ++i) {
            buf.append(keys[i]).append(": ").append(this.fsAddrToXmiIdMap.get(keys[i])).append('\n');
        }
        return buf.toString();
    }

    public static class XmiArrayElement {
        public int index;
        public String xmiId;

        XmiArrayElement(int index, String xmiId) {
            this.index = index;
            this.xmiId = xmiId;
        }
    }

    static class OotsElementData {
        String xmiId;
        XmlElementName elementName;
        List<XmlAttribute> attributes = new ArrayList<XmlAttribute>();
        List<XmlElementNameAndContents> childElements = new ArrayList<XmlElementNameAndContents>();

        OotsElementData() {
        }
    }
}

