/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XMLUtils {
    private static final String ACCESS_EXTERNAL_STYLESHEET = "http://javax.xml.XMLConstants/property/accessExternalStylesheet";
    private static final String ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";

    public static void normalize(String aStr, StringBuffer aResultBuf) {
        XMLUtils.normalize(aStr, aResultBuf, false);
    }

    public static void normalize(String aStr, StringBuffer aResultBuf, boolean aNewlinesToSpaces) {
        if (aStr != null) {
            int len = aStr.length();
            block8: for (int i = 0; i < len; ++i) {
                char c = aStr.charAt(i);
                if (c > '\u007f') {
                    aResultBuf.append("&#").append((int)c).append(';');
                    continue;
                }
                switch (c) {
                    case '<': {
                        aResultBuf.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        aResultBuf.append("&gt;");
                        continue block8;
                    }
                    case '&': {
                        aResultBuf.append("&amp;");
                        continue block8;
                    }
                    case '\"': {
                        aResultBuf.append("&quot;");
                        continue block8;
                    }
                    case '\n': {
                        aResultBuf.append(aNewlinesToSpaces ? " " : "\n");
                        continue block8;
                    }
                    case '\r': {
                        aResultBuf.append(aNewlinesToSpaces ? " " : "\r");
                        continue block8;
                    }
                    default: {
                        aResultBuf.append(c);
                    }
                }
            }
        }
    }

    public static void writeNormalizedString(String aStr, Writer aWriter, boolean aNewlinesToSpaces) throws IOException {
        if (aStr == null) {
            return;
        }
        int len = aStr.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = aStr.charAt(i);
            switch (c) {
                case '<': {
                    aWriter.write("&lt;");
                    continue block8;
                }
                case '>': {
                    aWriter.write("&gt;");
                    continue block8;
                }
                case '&': {
                    aWriter.write("&amp;");
                    continue block8;
                }
                case '\"': {
                    aWriter.write("&quot;");
                    continue block8;
                }
                case '\n': {
                    aWriter.write(aNewlinesToSpaces ? " " : "\n");
                    continue block8;
                }
                case '\r': {
                    aWriter.write(aNewlinesToSpaces ? " " : "\r");
                    continue block8;
                }
                default: {
                    aWriter.write(c);
                }
            }
        }
    }

    public static void writePrimitiveValue(Object aObj, Writer aWriter) throws IOException {
        String className = aObj.getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex > -1) {
            className = className.substring(lastDotIndex + 1).toLowerCase();
        }
        aWriter.write("<");
        aWriter.write(className);
        aWriter.write(">");
        XMLUtils.writeNormalizedString(aObj.toString(), aWriter, true);
        aWriter.write("</");
        aWriter.write(className);
        aWriter.write(">");
    }

    public static Element getChildByTagName(Element aElem, String aName) {
        NodeList matches = aElem.getElementsByTagName(aName);
        for (int i = 0; i < matches.getLength(); ++i) {
            Element childElem = (Element)matches.item(i);
            if (childElem.getParentNode() != aElem) continue;
            return childElem;
        }
        return null;
    }

    public static Element getFirstChildElement(Element aElem) {
        NodeList children = aElem.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node curNode = children.item(i);
            if (!(curNode instanceof Element)) continue;
            return (Element)curNode;
        }
        return null;
    }

    public static Object readPrimitiveValue(Element aElem) {
        String tagName = aElem.getTagName();
        if (tagName.endsWith("_p")) {
            tagName = tagName.substring(0, tagName.lastIndexOf("_p"));
        }
        char[] chars = tagName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String className = "java.lang." + new String(chars);
        String stringifiedObject = XMLUtils.getText(aElem, true);
        try {
            Class<?> theClass = Class.forName(className);
            Constructor<?> constructor = theClass.getConstructor(String.class);
            return constructor.newInstance(stringifiedObject);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getText(Element aElem) {
        StringBuffer buf = new StringBuffer();
        NodeList children = aElem.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node curNode = children.item(i);
            if (curNode instanceof Text) {
                buf.append(((Text)curNode).getData());
                continue;
            }
            if (!(curNode instanceof Element)) continue;
            buf.append('<').append(((Element)curNode).getTagName()).append('>');
            buf.append(XMLUtils.getText((Element)curNode));
            buf.append("</").append(((Element)curNode).getTagName()).append('>');
        }
        return buf.toString().trim();
    }

    public static String getText(Element aElem, boolean aExpandEnvVarRefs) {
        StringBuffer buf = new StringBuffer();
        NodeList children = aElem.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node curNode = children.item(i);
            if (curNode instanceof Text) {
                buf.append(((Text)curNode).getData());
                continue;
            }
            if (!(curNode instanceof Element)) continue;
            Element subElem = (Element)curNode;
            if (aExpandEnvVarRefs && "envVarRef".equals(subElem.getTagName())) {
                String varName = XMLUtils.getText(subElem, false);
                String value = System.getProperty(varName);
                if (value == null) continue;
                buf.append(value);
                continue;
            }
            buf.append('<').append(((Element)curNode).getTagName()).append('>');
            buf.append(XMLUtils.getText((Element)curNode, aExpandEnvVarRefs));
            buf.append("</").append(((Element)curNode).getTagName()).append('>');
        }
        return buf.toString().trim();
    }

    public static final int checkForNonXmlCharacters(String s) {
        return XMLUtils.checkForNonXmlCharacters(s, false);
    }

    public static final int checkForNonXmlCharacters(String s, boolean xml11) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < s.length(); ++i) {
            char cNext;
            int iNext;
            char c = s.charAt(i);
            if (XMLUtils.isValidXmlUtf16int(c, xml11)) continue;
            if (c >= '\ud800' && c <= '\udbff' && (iNext = i + 1) < s.length() && (cNext = s.charAt(iNext)) >= '\udc00' && cNext <= '\udfff') {
                ++i;
                continue;
            }
            return i;
        }
        return -1;
    }

    public static final int checkForNonXmlCharacters(char[] ch, int start, int length, boolean xml11) {
        if (ch == null) {
            return -1;
        }
        for (int i = start; i < start + length; ++i) {
            char cNext;
            int iNext;
            char c = ch[i];
            if (XMLUtils.isValidXmlUtf16int(c, xml11)) continue;
            if (c >= '\ud800' && c <= '\udbff' && (iNext = i + 1) < start + length && (cNext = ch[iNext]) >= '\udc00' && cNext <= '\udfff') {
                ++i;
                continue;
            }
            return i;
        }
        return -1;
    }

    private static final boolean isValidXmlUtf16int(char c, boolean xml11) {
        if (xml11) {
            return c >= '\u0001' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
        }
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }

    public static SAXParserFactory createSAXParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature(DISALLOW_DOCTYPE_DECL, true);
        }
        catch (SAXNotRecognizedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "SAXParserFactory didn't recognize feature http://apache.org/xml/features/disallow-doctype-decl");
        }
        catch (SAXNotSupportedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "SAXParserFactory doesn't support feature http://apache.org/xml/features/disallow-doctype-decl");
        }
        catch (ParserConfigurationException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "SAXParserFactory doesn't support feature http://apache.org/xml/features/disallow-doctype-decl");
        }
        try {
            factory.setFeature(LOAD_EXTERNAL_DTD, false);
        }
        catch (SAXNotRecognizedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "SAXParserFactory didn't recognize feature http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
        catch (SAXNotSupportedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "SAXParserFactory doesn't support feature http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
        catch (ParserConfigurationException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "SAXParserFactory doesn't support feature http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
        factory.setXIncludeAware(false);
        return factory;
    }

    public static XMLReader createXMLReader() throws SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        try {
            xmlReader.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
        }
        catch (SAXNotRecognizedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader didn't recognize feature http://xml.org/sax/features/external-general-entities");
        }
        catch (SAXNotSupportedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader doesn't support feature http://xml.org/sax/features/external-general-entities");
        }
        try {
            xmlReader.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        }
        catch (SAXNotRecognizedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader didn't recognize feature http://xml.org/sax/features/external-parameter-entities");
        }
        catch (SAXNotSupportedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader doesn't support feature http://xml.org/sax/features/external-parameter-entities");
        }
        try {
            xmlReader.setFeature(LOAD_EXTERNAL_DTD, false);
        }
        catch (SAXNotRecognizedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader didn't recognized feature http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
        catch (SAXNotSupportedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader doesn't support feature http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
        return xmlReader;
    }

    public static SAXTransformerFactory createSaxTransformerFactory() {
        SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            saxTransformerFactory.setAttribute(ACCESS_EXTERNAL_DTD, "");
        }
        catch (IllegalArgumentException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "SAXTransformerFactory didn't recognize setting attribute http://javax.xml.XMLConstants/property/accessExternalDTD");
        }
        try {
            saxTransformerFactory.setAttribute(ACCESS_EXTERNAL_STYLESHEET, "");
        }
        catch (IllegalArgumentException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "SAXTransformerFactory didn't recognize setting attribute http://javax.xml.XMLConstants/property/accessExternalStylesheet");
        }
        return saxTransformerFactory;
    }

    public static TransformerFactory createTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute(ACCESS_EXTERNAL_DTD, "");
        }
        catch (IllegalArgumentException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "TransformerFactory didn't recognize setting attribute http://javax.xml.XMLConstants/property/accessExternalDTD");
        }
        try {
            transformerFactory.setAttribute(ACCESS_EXTERNAL_STYLESHEET, "");
        }
        catch (IllegalArgumentException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "TransformerFactory didn't recognize setting attribute http://javax.xml.XMLConstants/property/accessExternalStylesheet");
        }
        return transformerFactory;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setFeature(DISALLOW_DOCTYPE_DECL, true);
        }
        catch (ParserConfigurationException e1) {
            UIMAFramework.getLogger().log(Level.WARNING, "DocumentBuilderFactory didn't recognize setting feature http://apache.org/xml/features/disallow-doctype-decl");
        }
        try {
            documentBuilderFactory.setFeature(LOAD_EXTERNAL_DTD, false);
        }
        catch (ParserConfigurationException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "DocumentBuilderFactory doesn't support feature http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        return documentBuilderFactory;
    }
}

