/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.property;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class AnnotationPropertyPage
extends PropertyPage {
    private boolean isTypeSystemPresent = true;
    private Combo mStyleCombo;
    private ColorSelector mColorSelector;
    private TableViewer mTypeList;
    private Button moveLayerUpButton;
    private Button moveLayerDownButton;
    private CustomStyleConfigWidget styleConfigurationWidget;
    private Map<Type, AnnotationStyle> changedStyles = new HashMap<Type, AnnotationStyle>();

    private Type getSelectedType() {
        IStructuredSelection selection = (IStructuredSelection)this.mTypeList.getSelection();
        return (Type)selection.getFirstElement();
    }

    protected abstract AnnotationStyle getAnnotationStyle(Type var1);

    private final AnnotationStyle getWorkingCopyAnnotationStyle(Type type) {
        AnnotationStyle style = this.changedStyles.get(type);
        if (style == null) {
            style = this.getAnnotationStyle(type);
        }
        return style;
    }

    protected final void setAnnotationStyle(AnnotationStyle style) {
        this.changedStyles.put(this.getSelectedType(), style);
    }

    protected abstract TypeSystem getTypeSystem();

    private void updateCustomStyleControl(AnnotationStyle style, Type selectedType) {
        if (AnnotationStyle.Style.TAG.equals((Object)style.getStyle())) {
            this.styleConfigurationWidget.setVisible(true);
            this.styleConfigurationWidget.setStyle(style, selectedType);
        } else {
            this.styleConfigurationWidget.setVisible(false);
        }
    }

    private void itemSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.mTypeList.getSelection();
        Type selectedType = (Type)selection.getFirstElement();
        if (selectedType != null) {
            AnnotationStyle style = this.getWorkingCopyAnnotationStyle(selectedType);
            if (style == null) {
                style = new AnnotationStyle(selectedType.getName(), AnnotationStyle.DEFAULT_STYLE, AnnotationStyle.DEFAULT_COLOR, 0);
            }
            this.mStyleCombo.setText(style.getStyle().name());
            this.mStyleCombo.setEnabled(true);
            Color color = style.getColor();
            this.mColorSelector.setColorValue(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
            this.mColorSelector.setEnabled(true);
            this.moveLayerUpButton.setEnabled(true);
            this.moveLayerDownButton.setEnabled(true);
            this.updateCustomStyleControl(style, selectedType);
        } else {
            this.mStyleCombo.setEnabled(false);
            this.mColorSelector.setEnabled(false);
            this.moveLayerUpButton.setEnabled(false);
            this.moveLayerDownButton.setEnabled(false);
            this.styleConfigurationWidget.setVisible(false);
        }
    }

    protected Control createContents(Composite parent) {
        AnnotationStyle.Style[] possibleStyles;
        this.setSize(new Point(350, 350));
        TypeSystem typeSystem = this.getTypeSystem();
        if (typeSystem == null) {
            this.isTypeSystemPresent = false;
            Label message = new Label(parent, 0);
            message.setText("Please set a valid typesystem file first.");
            return message;
        }
        Composite base = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        base.setLayout((Layout)layout);
        Label typeText = new Label(base, 0);
        typeText.setText("Annotation types:");
        GridData typeTextGridData = new GridData();
        typeTextGridData.horizontalSpan = 2;
        typeText.setLayoutData((Object)typeTextGridData);
        this.mTypeList = new TableViewer(base, 2564);
        GridData typeListGridData = new GridData();
        typeListGridData.horizontalAlignment = 4;
        typeListGridData.grabExcessVerticalSpace = true;
        typeListGridData.verticalAlignment = 4;
        typeListGridData.verticalSpan = 2;
        this.mTypeList.getControl().setLayoutData((Object)typeListGridData);
        this.mTypeList.getTable().setHeaderVisible(true);
        TableViewerColumn typeColumn = new TableViewerColumn(this.mTypeList, 16384);
        typeColumn.getColumn().setText("Type");
        typeColumn.getColumn().setWidth(250);
        typeColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Type type = (Type)cell.getElement();
                cell.setText(type.getName());
            }
        });
        TableViewerColumn layerColumn = new TableViewerColumn(this.mTypeList, 16384);
        layerColumn.getColumn().setText("Layer");
        layerColumn.getColumn().setWidth(50);
        layerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Type type = (Type)cell.getElement();
                AnnotationStyle style = AnnotationPropertyPage.this.getWorkingCopyAnnotationStyle(type);
                cell.setText(Integer.toString(style.getLayer()));
            }
        });
        Type annotationType = typeSystem.getType("uima.tcas.Annotation");
        List types = typeSystem.getProperlySubsumedTypes(annotationType);
        for (Type type : types) {
            this.mTypeList.add((Object)type);
        }
        this.mTypeList.add((Object)annotationType);
        this.mTypeList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AnnotationPropertyPage.this.itemSelected();
            }
        });
        Composite settingsComposite = new Composite(base, 0);
        GridLayout settingsLayout = new GridLayout();
        settingsLayout.numColumns = 2;
        settingsComposite.setLayout((Layout)settingsLayout);
        Label styleText = new Label(settingsComposite, 8);
        styleText.setText("Style:");
        this.mStyleCombo = new Combo(settingsComposite, 12);
        this.mStyleCombo.setEnabled(false);
        this.mStyleCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String configString;
                AnnotationStyle style = AnnotationPropertyPage.this.getWorkingCopyAnnotationStyle(AnnotationPropertyPage.this.getSelectedType());
                AnnotationStyle newStyle = new AnnotationStyle(style.getAnnotation(), AnnotationStyle.Style.valueOf(AnnotationPropertyPage.this.mStyleCombo.getText()), style.getColor(), style.getLayer(), style.getConfiguration());
                AnnotationPropertyPage.this.updateCustomStyleControl(newStyle, AnnotationPropertyPage.this.getSelectedType());
                if (AnnotationPropertyPage.this.styleConfigurationWidget.isVisible() && (configString = AnnotationPropertyPage.this.styleConfigurationWidget.getConfiguration()) != null) {
                    newStyle = new AnnotationStyle(newStyle.getAnnotation(), newStyle.getStyle(), newStyle.getColor(), newStyle.getLayer(), configString);
                }
                AnnotationPropertyPage.this.setAnnotationStyle(newStyle);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        for (AnnotationStyle.Style style : possibleStyles = AnnotationStyle.Style.values()) {
            this.mStyleCombo.add(style.name());
        }
        Label colorText = new Label(settingsComposite, 0);
        colorText.setText("Color:");
        this.mColorSelector = new ColorSelector(settingsComposite);
        this.mColorSelector.setEnabled(false);
        this.mColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AnnotationStyle style = AnnotationPropertyPage.this.getWorkingCopyAnnotationStyle(AnnotationPropertyPage.this.getSelectedType());
                RGB colorRGB = AnnotationPropertyPage.this.mColorSelector.getColorValue();
                Color color = new Color(colorRGB.red, colorRGB.green, colorRGB.blue);
                AnnotationPropertyPage.this.setAnnotationStyle(new AnnotationStyle(style.getAnnotation(), style.getStyle(), color, style.getLayer(), style.getConfiguration()));
            }
        });
        this.moveLayerUpButton = new Button(settingsComposite, 0);
        this.moveLayerUpButton.setText("Move layer up");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.moveLayerUpButton);
        this.moveLayerUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AnnotationStyle style = AnnotationPropertyPage.this.getWorkingCopyAnnotationStyle(AnnotationPropertyPage.this.getSelectedType());
                AnnotationPropertyPage.this.setAnnotationStyle(new AnnotationStyle(style.getAnnotation(), AnnotationStyle.Style.valueOf(AnnotationPropertyPage.this.mStyleCombo.getText()), style.getColor(), style.getLayer() + 1, style.getConfiguration()));
                AnnotationPropertyPage.this.mTypeList.update((Object)AnnotationPropertyPage.this.getSelectedType(), null);
            }
        });
        this.moveLayerDownButton = new Button(settingsComposite, 0);
        this.moveLayerDownButton.setText("Move layer down");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.moveLayerDownButton);
        this.moveLayerDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AnnotationStyle style = AnnotationPropertyPage.this.getWorkingCopyAnnotationStyle(AnnotationPropertyPage.this.getSelectedType());
                if (style.getLayer() - 1 >= 0) {
                    AnnotationPropertyPage.this.setAnnotationStyle(new AnnotationStyle(style.getAnnotation(), AnnotationStyle.Style.valueOf(AnnotationPropertyPage.this.mStyleCombo.getText()), style.getColor(), style.getLayer() - 1, style.getConfiguration()));
                    AnnotationPropertyPage.this.mTypeList.update((Object)AnnotationPropertyPage.this.getSelectedType(), null);
                }
            }
        });
        this.styleConfigurationWidget = new TagStyleConfigWidget(settingsComposite);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.styleConfigurationWidget);
        this.styleConfigurationWidget.setVisible(false);
        this.styleConfigurationWidget.addListener(new CustomStyleConfigChangeListener(){

            @Override
            public void styleChanged(String configuration) {
                AnnotationStyle style = AnnotationPropertyPage.this.getWorkingCopyAnnotationStyle(AnnotationPropertyPage.this.getSelectedType());
                AnnotationPropertyPage.this.setAnnotationStyle(new AnnotationStyle(style.getAnnotation(), style.getStyle(), style.getColor(), style.getLayer(), configuration));
            }
        });
        this.mTypeList.getTable().select(0);
        if (this.mTypeList.getTable().getSelectionIndex() != -1) {
            this.itemSelected();
        }
        return base;
    }

    protected abstract boolean saveChanges(Collection<AnnotationStyle> var1);

    public boolean performOk() {
        if (!this.isTypeSystemPresent) {
            return true;
        }
        if (!this.saveChanges(this.changedStyles.values())) {
            return false;
        }
        this.changedStyles.clear();
        return true;
    }

    private static class TagStyleConfigWidget
    extends CustomStyleConfigWidget {
        private Combo featureCombo;

        TagStyleConfigWidget(Composite parent) {
            super(parent);
            this.setLayout((Layout)new FillLayout());
            Group group = new Group((Composite)this, 0);
            group.setText("Tag Style Settings");
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            Label warning = new Label((Composite)group, 0);
            warning.setText("The tag style is experimental\nand has still minor issues!");
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)warning);
            Label featureLabel = new Label((Composite)group, 0);
            featureLabel.setText("Feature:");
            GridDataFactory.fillDefaults().applyTo((Control)featureLabel);
            this.featureCombo = new Combo((Composite)group, 12);
            GridDataFactory.fillDefaults().applyTo((Control)this.featureCombo);
            this.featureCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TagStyleConfigWidget.this.notifyChange(TagStyleConfigWidget.this.featureCombo.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            group.pack();
        }

        @Override
        String getConfiguration() {
            String configString = this.featureCombo.getText();
            if (configString.length() == 0) {
                return null;
            }
            return configString;
        }

        @Override
        void setStyle(AnnotationStyle style, Type selectedType) {
            int indexToSelect;
            this.featureCombo.removeAll();
            for (Feature feature : selectedType.getFeatures()) {
                if (!feature.getRange().isPrimitive()) continue;
                String featureName = feature.getShortName();
                this.featureCombo.add(featureName);
            }
            this.featureCombo.select(0);
            String feature = style.getConfiguration();
            if (feature != null && (indexToSelect = this.featureCombo.indexOf(feature)) != -1) {
                this.featureCombo.select(indexToSelect);
            }
        }
    }

    private static abstract class CustomStyleConfigWidget
    extends Composite {
        private Set<CustomStyleConfigChangeListener> listeners = new HashSet<CustomStyleConfigChangeListener>();

        public CustomStyleConfigWidget(Composite parent) {
            super(parent, 0);
        }

        protected void notifyChange(String newConfig) {
            for (CustomStyleConfigChangeListener listener : this.listeners) {
                listener.styleChanged(newConfig);
            }
        }

        void addListener(CustomStyleConfigChangeListener listener) {
            this.listeners.add(listener);
        }

        void removeListener(CustomStyleConfigChangeListener listener) {
            this.listeners.remove(listener);
        }

        void setStyle(AnnotationStyle style, Type selectedType) {
        }

        abstract String getConfiguration();
    }

    private static interface CustomStyleConfigChangeListener {
        public void styleChanged(String var1);
    }
}

