/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.aae.jmx.JmxManagement;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.asb.impl.FlowControllerContainer;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.flow.impl.FlowControllerContext_impl;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class UimaClassFactory {
    public static final String IMPORT_BY_NAME_PREFIX = "*importByName:";

    public static ResourceSpecifier produceResourceSpecifier(String aFileResource) throws InvalidXMLException, ResourceInitializationException, IOException {
        XMLInputSource input = UimaClassFactory.resolveImportByName(aFileResource, UIMAFramework.newDefaultResourceManager());
        return UIMAFramework.getXMLParser().parseResourceSpecifier(input);
    }

    public static ResourceManager produceResourceManager() {
        return UIMAFramework.newDefaultResourceManager();
    }

    private static XMLInputSource resolveImportByName(String aFileResource, ResourceManager aResourceManager) throws InvalidXMLException, ResourceInitializationException, IOException {
        XMLInputSource input;
        if (aFileResource.startsWith(IMPORT_BY_NAME_PREFIX)) {
            Import_impl theImport = new Import_impl();
            theImport.setName(aFileResource.substring(IMPORT_BY_NAME_PREFIX.length()));
            input = new XMLInputSource(theImport.findAbsoluteUrl(aResourceManager));
        } else {
            input = new XMLInputSource(aFileResource);
        }
        return input;
    }

    public static FlowControllerContainer produceAggregateFlowControllerContainer(AnalysisEngineDescription aeSpecifier, String aFlowControllerDescriptor, Map anAggregateMergedTypeSystem, UimaContextAdmin aParentContext, SofaMapping[] aSofaMappings, JmxManagement aJmxManagementInterface) throws InvalidXMLException, ResourceInitializationException, IOException {
        FlowControllerDeclaration fcd = aeSpecifier.getFlowControllerDeclaration();
        String key = "_FlowController";
        if (fcd != null && fcd.getKey() != null && fcd.getKey().trim().length() > 0) {
            key = fcd.getKey();
        }
        ResourceManager resourceManager = aParentContext.getRootContext().getResourceManager();
        XMLInputSource input = UimaClassFactory.resolveImportByName(aFlowControllerDescriptor, resourceManager);
        FlowControllerDescription specifier = (FlowControllerDescription)UIMAFramework.getXMLParser().parseResourceSpecifier(input);
        AnalysisEngineMetaData anAggregateMetadata = aeSpecifier.getAnalysisEngineMetaData();
        TreeMap<String, String> sofamap = new TreeMap<String, String>();
        if (aSofaMappings != null && aSofaMappings.length > 0) {
            for (int s = 0; s < aSofaMappings.length; ++s) {
                if (!aSofaMappings[s].getComponentKey().equals(key)) continue;
                if (aSofaMappings[s].getComponentSofaName() == null) {
                    aSofaMappings[s].setComponentSofaName("_InitialView");
                }
                sofamap.put(aSofaMappings[s].getComponentSofaName(), aSofaMappings[s].getAggregateSofaName());
            }
        }
        HashMap<String, Object> flowControllerParams = new HashMap<String, Object>();
        FlowControllerContext_impl fctx = new FlowControllerContext_impl(aParentContext, key, sofamap, anAggregateMergedTypeSystem, anAggregateMetadata);
        flowControllerParams.put("UIMA_CONTEXT", fctx);
        flowControllerParams.put("RESOURCE_MANAGER", resourceManager);
        flowControllerParams.put("MBEAN_NAME_PREFIX", aJmxManagementInterface.getJmxDomain());
        if (aJmxManagementInterface.getMBeanServer() != null) {
            flowControllerParams.put("MBEAN_SERVER", aJmxManagementInterface.getMBeanServer());
        }
        FlowControllerContainer flowControllerContainer = new FlowControllerContainer();
        flowControllerContainer.initialize((ResourceSpecifier)specifier, flowControllerParams);
        return flowControllerContainer;
    }
}

