/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.UimaAsVersion;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.impl.UimaVersion;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public class VersionCompatibilityChecker {
    public static void check(Class<?> claz, String componentName, String method) throws ResourceInitializationException {
        boolean minorOK;
        boolean majorMatch = UimaAsVersion.getMajorVersion() == UimaVersion.getMajorVersion();
        boolean bl = minorOK = UimaAsVersion.getMinorVersion() <= UimaVersion.getMinorVersion();
        if (!majorMatch || majorMatch && !minorOK) {
            UIMAFramework.getLogger(claz).logrb(Level.WARNING, claz.getName(), method, "uimaee_messages", "UIMAEE_incompatible_version_WARNING", new Object[]{componentName, UimaAsVersion.getFullVersionString(), UimaVersion.getFullVersionString()});
            throw new ResourceInitializationException((Throwable)new AsynchAEException("Version of UIMA-AS is Incompatible with a Version of UIMA Core. UIMA-AS Version is built to depend on Core UIMA version:" + UimaAsVersion.getFullVersionString() + " but is running with version:" + UimaVersion.getFullVersionString()));
        }
    }
}

