/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.jmx;

import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.jmx.ServicePerformanceMBean;

public class ServicePerformance
implements ServicePerformanceMBean {
    private static final long serialVersionUID = 1L;
    private static final String label = "Service Performance";
    private long idleTime = 0L;
    private long numberOfCASesProcessed = 0L;
    private long casDeserializationTime = 0L;
    private long casSerializationTime = 0L;
    private long analysisTime = 0L;
    private long maxSerializationTime = 0L;
    private long maxDeserializationTime = 0L;
    private long maxAnalysisTime = 0L;
    private long casPoolWaitTime = 0L;
    private long shadowCasPoolWaitTime = 0L;
    private long timeSpentInCMGetNext = 0L;
    private Object sem = new Object();
    private AnalysisEngineController controller;
    private boolean isRemoteDelegate = false;
    private long uptime = System.nanoTime();
    long lastUpdate = System.nanoTime();
    private int processThreadCount = 1;
    private Object waitmux = new Object();
    private boolean waitingForCAS = false;
    private long totalWaitTimeForCAS = 0L;
    private long lastCASWaitTimeUpdate = 0L;
    private Object shadowPoolMux = new Object();
    private boolean waitingForSPCAS = false;
    private long lastSPCASWaitTimeUpdate = 0L;
    private Object getNextMux = new Object();
    private boolean waitingInGetNext = false;
    private long lastGetNextWaitTimeUpdate = 0L;
    private long totalGetNextWaitTime = 0L;
    private int replyThreadCount = 1;

    public ServicePerformance() {
    }

    public ServicePerformance(AnalysisEngineController aController) {
        this.controller = aController;
    }

    public void setRemoteDelegate() {
        this.isRemoteDelegate = true;
    }

    public String getLabel() {
        return label;
    }

    @Override
    public synchronized void reset() {
        this.idleTime = 0L;
        this.numberOfCASesProcessed = 0L;
        this.casDeserializationTime = 0L;
        this.casSerializationTime = 0L;
        this.casPoolWaitTime = 0L;
        this.shadowCasPoolWaitTime = 0L;
        this.analysisTime = 0L;
        this.maxSerializationTime = 0L;
        this.maxDeserializationTime = 0L;
        this.maxAnalysisTime = 0L;
        this.timeSpentInCMGetNext = 0L;
        this.uptime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTime(long anIdleTime) {
        Object object = this.sem;
        synchronized (object) {
            this.idleTime = anIdleTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getIdleTime() {
        if (this.controller != null) {
            return (double)this.controller.getIdleTime() / 1000000.0;
        }
        Object object = this.sem;
        synchronized (object) {
            return (double)this.idleTime / 1000000.0;
        }
    }

    public long getRawIdleTime() {
        return this.idleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementIdleTime(long anIdleTime) {
        Object object = this.sem;
        synchronized (object) {
            this.idleTime += anIdleTime;
            this.lastUpdate = System.nanoTime();
        }
    }

    public synchronized void setAnalysisTime(long anAnalysisTime) {
        this.analysisTime = anAnalysisTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void incrementAnalysisTime(long anAnalysisTime) {
        Object object = this.sem;
        synchronized (object) {
            if (this.maxAnalysisTime < anAnalysisTime) {
                this.maxAnalysisTime = anAnalysisTime;
            }
            this.analysisTime += anAnalysisTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized double getAnalysisTime() {
        if (this.controller != null) {
            return (double)this.controller.getAnalysisTime() / 1000000.0;
        }
        Object object = this.sem;
        synchronized (object) {
            return (double)this.analysisTime / 1000000.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getRawAnalysisTime() {
        if (this.controller != null) {
            return this.controller.getAnalysisTime();
        }
        Object object = this.sem;
        synchronized (object) {
            return this.analysisTime;
        }
    }

    @Override
    public long getNumberOfCASesProcessed() {
        return this.numberOfCASesProcessed;
    }

    public synchronized void incrementNumberOfCASesProcessed() {
        ++this.numberOfCASesProcessed;
    }

    @Override
    public synchronized double getCasDeserializationTime() {
        if (this.casDeserializationTime > 0L) {
            return (double)this.casDeserializationTime / 1000000.0;
        }
        return 0.0;
    }

    public synchronized long getRawCasDeserializationTime() {
        return this.casDeserializationTime;
    }

    public synchronized void incrementCasDeserializationTime(long aCasDeserializationTime) {
        if (this.maxDeserializationTime < aCasDeserializationTime) {
            this.maxDeserializationTime = aCasDeserializationTime;
        }
        this.casDeserializationTime += aCasDeserializationTime;
    }

    @Override
    public double getCasSerializationTime() {
        return (double)this.casSerializationTime / 1000000.0;
    }

    public long getRawCasSerializationTime() {
        return this.casSerializationTime;
    }

    public synchronized void incrementCasSerializationTime(long casSerializationTime) {
        if (this.maxSerializationTime < casSerializationTime) {
            this.maxSerializationTime = casSerializationTime;
        }
        this.casSerializationTime += casSerializationTime;
    }

    public double getMaxSerializationTime() {
        return (double)this.maxSerializationTime / 1000000.0;
    }

    public double getMaxDeserializationTime() {
        return (double)this.maxDeserializationTime / 1000000.0;
    }

    public double getMaxAnalysisTime() {
        return (double)this.maxAnalysisTime / 1000000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCasPoolWaitTime(long aCasPoolsWaitTime) {
        Object object = this.sem;
        synchronized (object) {
            this.casPoolWaitTime += aCasPoolsWaitTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getCasPoolWaitTime() {
        Object object = this.sem;
        synchronized (object) {
            if (this.controller != null) {
                return (double)this.getTimeWaitingForCAS() / 1000000.0;
            }
            return (double)this.casPoolWaitTime / 1000000.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRawCasPoolWaitTime() {
        Object object = this.sem;
        synchronized (object) {
            return this.casPoolWaitTime;
        }
    }

    @Override
    public double getShadowCasPoolWaitTime() {
        return (double)this.getTimeWaitingForShadowPoolCAS() / 1000000.0;
    }

    @Override
    public double getTimeSpentInCMGetNext() {
        return (double)this.getTimeWaitingInGetNext() / 1000000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginWaitOnCASPool() {
        Object object = this.waitmux;
        synchronized (object) {
            if (!this.waitingForCAS) {
                this.waitingForCAS = true;
                this.lastCASWaitTimeUpdate = System.nanoTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endWaitOnCASPool() {
        Object object = this.waitmux;
        synchronized (object) {
            long delta = System.nanoTime() - this.lastCASWaitTimeUpdate;
            this.totalWaitTimeForCAS += delta;
            this.waitingForCAS = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeWaitingForCAS() {
        Object object = this.waitmux;
        synchronized (object) {
            long now = System.nanoTime();
            if (this.waitingForCAS) {
                long delta = System.nanoTime() - this.lastCASWaitTimeUpdate;
                this.totalWaitTimeForCAS += delta;
                this.lastCASWaitTimeUpdate = now;
            }
            return this.totalWaitTimeForCAS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginWaitOnShadowCASPool() {
        Object object = this.shadowPoolMux;
        synchronized (object) {
            if (!this.waitingForSPCAS) {
                this.waitingForSPCAS = true;
                this.lastSPCASWaitTimeUpdate = System.nanoTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endWaitOnShadowCASPool() {
        Object object = this.shadowPoolMux;
        synchronized (object) {
            long delta = System.nanoTime() - this.lastSPCASWaitTimeUpdate;
            this.shadowCasPoolWaitTime += delta;
            this.waitingForSPCAS = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeWaitingForShadowPoolCAS() {
        Object object = this.shadowPoolMux;
        synchronized (object) {
            long now = System.nanoTime();
            if (this.waitingForSPCAS) {
                long delta = System.nanoTime() - this.lastSPCASWaitTimeUpdate;
                this.shadowCasPoolWaitTime += delta;
                this.lastSPCASWaitTimeUpdate = now;
            }
            return this.shadowCasPoolWaitTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginGetNextWait() {
        Object object = this.getNextMux;
        synchronized (object) {
            if (!this.waitingInGetNext) {
                this.waitingInGetNext = true;
                this.lastGetNextWaitTimeUpdate = System.nanoTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endGetNextWait() {
        Object object = this.getNextMux;
        synchronized (object) {
            long delta = System.nanoTime() - this.lastGetNextWaitTimeUpdate;
            this.totalGetNextWaitTime += delta;
            this.waitingInGetNext = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeWaitingInGetNext() {
        Object object = this.getNextMux;
        synchronized (object) {
            long now = System.nanoTime();
            if (this.waitingInGetNext) {
                long delta = System.nanoTime() - this.lastGetNextWaitTimeUpdate;
                this.totalGetNextWaitTime += delta;
                this.lastGetNextWaitTimeUpdate = now;
            }
            return this.totalGetNextWaitTime;
        }
    }

    @Override
    public int getProcessThreadCount() {
        return this.processThreadCount;
    }

    public void setProcessThreadCount(int processThreadCount) {
        this.processThreadCount = processThreadCount;
    }

    @Override
    public int getReplyThreadCount() {
        return this.replyThreadCount;
    }

    @Override
    public void setReplyThreadCount(int replyThreadCount) {
        this.replyThreadCount = replyThreadCount;
    }
}

