/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.jmx;

import org.apache.uima.aae.jmx.UimaASClientInfoMBean;
import org.apache.uima.cas.SerialFormat;

public class UimaASClientInfo
implements UimaASClientInfoMBean {
    private String applicationName;
    private long idleTime;
    private long serializationTime;
    private long deserializationTime;
    private long totalCasesProcessed;
    private long totalCasesRequested;
    private long totalProcessTime;
    private long totalTimeWaitingForReply;
    private long totalResponseLatencyTime;
    private long totalTimeWaitingForCas;
    private long maxSerializationTime;
    private long maxDeserializationTime;
    private long maxIdleTime;
    private long maxProcessTime;
    private long maxTimeWaitingForReply;
    private long maxResponseLatencyTime;
    private long maxTimeWaitingForCas;
    private String endpointName;
    private int replyWindowSize;
    private int casPoolSize;
    private long _metaTimeoutErrorCount;
    private long _processTimeoutErrorCount;
    private long _processErrorCount;
    private long _metaErrorCount;
    private SerialFormat serialFormat = SerialFormat.XMI;

    @Override
    public synchronized void reset() {
        this.idleTime = 0L;
        this.serializationTime = 0L;
        this.deserializationTime = 0L;
        this.totalCasesProcessed = 0L;
        this.totalCasesRequested = 0L;
        this.totalProcessTime = 0L;
        this.totalTimeWaitingForReply = 0L;
        this.totalResponseLatencyTime = 0L;
        this.totalTimeWaitingForCas = 0L;
        this.maxSerializationTime = 0L;
        this.maxDeserializationTime = 0L;
        this.maxIdleTime = 0L;
        this.maxProcessTime = 0L;
        this.maxTimeWaitingForReply = 0L;
        this.maxResponseLatencyTime = 0L;
        this.maxTimeWaitingForCas = 0L;
        this._metaTimeoutErrorCount = 0L;
        this._processTimeoutErrorCount = 0L;
        this._processErrorCount = 0L;
        this._metaErrorCount = 0L;
    }

    @Override
    public synchronized long getMetaErrorCount() {
        return this._metaErrorCount;
    }

    @Override
    public synchronized void incrementMetaErrorCount() {
        ++this._metaErrorCount;
    }

    @Override
    public synchronized long getMetaTimeoutErrorCount() {
        return this._metaTimeoutErrorCount;
    }

    @Override
    public synchronized void incrementMetaTimeoutErrorCount() {
        ++this._metaTimeoutErrorCount;
    }

    @Override
    public synchronized long getProcessTimeoutErrorCount() {
        return this._processTimeoutErrorCount;
    }

    @Override
    public synchronized void incrementProcessTimeoutErrorCount() {
        ++this._processTimeoutErrorCount;
    }

    @Override
    public synchronized long getProcessErrorCount() {
        return this._processErrorCount;
    }

    @Override
    public synchronized void incrementProcessErrorCount() {
        ++this._processErrorCount;
    }

    @Override
    public String getEndpointName() {
        return this.endpointName;
    }

    @Override
    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public int getReplyWindowSize() {
        return this.replyWindowSize;
    }

    public void setReplyWindowSize(int replyWindowSize) {
        this.replyWindowSize = replyWindowSize;
    }

    @Override
    public int getCasPoolSize() {
        return this.casPoolSize;
    }

    @Override
    public void setCasPoolSize(int casPoolSize) {
        this.casPoolSize = casPoolSize;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    private String format(double aValue) {
        return String.format("%,.2f ms", aValue);
    }

    @Override
    public synchronized String getAverageDeserializationTime() {
        if (this.totalCasesProcessed > 0L) {
            double floatValue = (double)this.deserializationTime / (double)this.totalCasesProcessed / 1000000.0;
            return this.format(floatValue);
        }
        return "0.0";
    }

    @Override
    public synchronized String getAverageIdleTime() {
        if (this.totalCasesProcessed > 0L) {
            double floatValue = (double)this.idleTime / (double)this.totalCasesProcessed / 1000000.0;
            return this.format(floatValue);
        }
        return "0.0";
    }

    @Override
    public synchronized String getAverageSerializationTime() {
        if (this.totalCasesProcessed > 0L) {
            double floatValue = (double)this.serializationTime / (double)this.totalCasesProcessed / 1000000.0;
            return this.format(floatValue);
        }
        return "0.0";
    }

    @Override
    public synchronized String getAverageTimeToProcessCas() {
        if (this.totalCasesProcessed > 0L) {
            double floatValue = (double)this.totalProcessTime / (double)this.totalCasesProcessed / 1000000.0;
            return this.format(floatValue);
        }
        return "0.0";
    }

    @Override
    public synchronized String getAverageTimeWaitingForReply() {
        return this.totalCasesProcessed > 0L ? this.format((double)this.totalTimeWaitingForReply / (double)this.totalCasesProcessed / 1000000.0) : "0.0";
    }

    @Override
    public synchronized String getAverageResponseLatencyTime() {
        return this.totalCasesProcessed > 0L ? this.format((double)this.totalResponseLatencyTime / (double)this.totalCasesProcessed / 1000000.0) : "0.0";
    }

    @Override
    public synchronized String getAverageTimeWaitingForCas() {
        return this.totalCasesRequested > 0L ? this.format((double)this.totalTimeWaitingForCas / (double)this.totalCasesRequested / 1000000.0) : "0.0";
    }

    @Override
    public synchronized String getMaxDeserializationTime() {
        return this.format((double)this.maxDeserializationTime / 1000000.0);
    }

    @Override
    public synchronized String getMaxIdleTime() {
        return this.format((double)this.maxIdleTime / 1000000.0);
    }

    @Override
    public synchronized String getMaxProcessTime() {
        return this.format((double)this.maxProcessTime / 1000000.0);
    }

    @Override
    public synchronized String getMaxSerializationTime() {
        return this.format((double)this.maxSerializationTime / 1000000.0);
    }

    @Override
    public synchronized String getMaxTimeWaitingForReply() {
        return this.format((double)this.maxTimeWaitingForReply / 1000000.0);
    }

    @Override
    public synchronized String getMaxResponseLatencyTime() {
        return this.format((double)this.maxResponseLatencyTime / 1000000.0);
    }

    @Override
    public synchronized String getMaxTimeWaitingForCas() {
        return this.format((double)this.maxTimeWaitingForCas / 1000000.0);
    }

    @Override
    public synchronized String getTotalDeserializationTime() {
        return this.format((double)this.deserializationTime / 1000000.0);
    }

    @Override
    public synchronized String getTotalIdleTime() {
        return this.format((double)this.idleTime / 1000000.0);
    }

    @Override
    public synchronized long getTotalNumberOfCasesProcessed() {
        return this.totalCasesProcessed;
    }

    @Override
    public synchronized long getTotalNumberOfCasesRequested() {
        return this.totalCasesRequested;
    }

    @Override
    public synchronized String getTotalSerializationTime() {
        return this.format((double)this.serializationTime / 1000000.0);
    }

    @Override
    public synchronized String getTotalTimeToProcess() {
        return this.format((double)this.totalProcessTime / 1000000.0);
    }

    @Override
    public synchronized String getTotalTimeWaitingForReply() {
        return this.format((double)this.totalTimeWaitingForReply / 1000000.0);
    }

    @Override
    public synchronized String getTotalResponseLatencyTime() {
        return this.format((double)this.totalResponseLatencyTime / 1000000.0);
    }

    @Override
    public synchronized String getTotalTimeWaitingForCas() {
        return this.format((double)this.totalTimeWaitingForCas / 1000000.0);
    }

    @Override
    public void setApplicationName(String anApplicationName) {
        this.applicationName = anApplicationName;
    }

    @Override
    public synchronized void incrementTotalIdleTime(long anIdleTime) {
        if (this.maxIdleTime < anIdleTime) {
            this.maxIdleTime = anIdleTime;
        }
        this.idleTime += anIdleTime;
    }

    @Override
    public synchronized void incrementTotalNumberOfCasesProcessed() {
        ++this.totalCasesProcessed;
    }

    @Override
    public synchronized void incrementTotalSerializationTime(long aSerializationTime) {
        if (this.maxSerializationTime < aSerializationTime) {
            this.maxSerializationTime = aSerializationTime;
        }
        this.serializationTime += aSerializationTime;
    }

    @Override
    public synchronized void incrementTotalTimeToProcess(long aTimeToProcess) {
        if (this.maxProcessTime < aTimeToProcess) {
            this.maxProcessTime = aTimeToProcess;
        }
        this.totalProcessTime += aTimeToProcess;
    }

    @Override
    public synchronized void incrementTotalDeserializationTime(long aDeserializationTime) {
        if (this.maxDeserializationTime < aDeserializationTime) {
            this.maxDeserializationTime = aDeserializationTime;
        }
        this.deserializationTime += aDeserializationTime;
    }

    @Override
    public synchronized void incrementTotalTimeWaitingForReply(long aTimeWaitingForReply) {
        if (this.maxTimeWaitingForReply < aTimeWaitingForReply) {
            this.maxTimeWaitingForReply = aTimeWaitingForReply;
        }
        this.totalTimeWaitingForReply += aTimeWaitingForReply;
    }

    @Override
    public synchronized void incrementTotalResponseLatencyTime(long aResponseLatencyTime) {
        if (this.maxResponseLatencyTime < aResponseLatencyTime) {
            this.maxResponseLatencyTime = aResponseLatencyTime;
        }
        this.totalResponseLatencyTime += aResponseLatencyTime;
    }

    @Override
    public synchronized void incrementTotalTimeWaitingForCas(long aTimeWaitingForCas) {
        ++this.totalCasesRequested;
        if (this.maxTimeWaitingForCas < aTimeWaitingForCas) {
            this.maxTimeWaitingForCas = aTimeWaitingForCas;
        }
        this.totalTimeWaitingForCas += aTimeWaitingForCas;
    }

    @Override
    public SerialFormat getSerialization() {
        return this.serialFormat;
    }

    @Override
    public void setSerialization(SerialFormat serialFormat) {
        this.serialFormat = serialFormat;
    }
}

