/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.ValueTailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class TailExpression
extends Expression {
    Expression base;
    int start;

    public TailExpression(Expression expression, int n) {
        this.base = expression;
        this.start = n;
        this.adoptChildExpression(expression);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.base = this.base.typeCheck(staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.base = this.base.optimize(optimizer, staticContext, itemType);
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            this.base = this.doPromotion(this.base, promotionOffer);
        }
        return this;
    }

    public int computeSpecialProperties() {
        return this.base.getSpecialProperties();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.base.getItemType(typeHierarchy);
    }

    public int computeCardinality() {
        return this.base.getCardinality() | 0x2000;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.base);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.base == expression) {
            this.base = expression2;
            bl = true;
        }
        return bl;
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public int getStart() {
        return this.start;
    }

    public boolean equals(Object object) {
        return object instanceof TailExpression && this.base.equals(((TailExpression)object).base) && this.start == ((TailExpression)object).start;
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.base.iterate(xPathContext);
        if ((sequenceIterator.getProperties() & 1) != 0) {
            return new ValueTailIterator(((GroundedIterator)sequenceIterator).materialize(), this.start - 1);
        }
        return TailIterator.make(sequenceIterator, this.start);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "tail " + this.start);
        this.base.display(n + 1, printStream, configuration);
    }
}

