/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class ExtensionFunctionCall
extends FunctionCall {
    private transient AccessibleObject theMethod;
    private MethodRepresentation persistentMethod;
    private transient Class[] theParameterTypes;
    private Class theClass;
    private Configuration config;

    public void init(int n, Class clazz, AccessibleObject accessibleObject, Configuration configuration) {
        this.setFunctionNameCode(n);
        this.theClass = clazz;
        this.theMethod = accessibleObject;
        this.theParameterTypes = null;
        this.config = configuration;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
    }

    public int getIntrinsicDependencies() {
        Class<?>[] classArray;
        int n = 0x1000000;
        if (this.theMethod instanceof Method && (classArray = ((Method)this.theMethod).getParameterTypes()).length > 0 && classArray[0] == XPathContext.class) {
            n |= 0xE;
        }
        return n;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        ValueRepresentation[] valueRepresentationArray = new ValueRepresentation[this.argument.length];
        for (int i = 0; i < valueRepresentationArray.length; ++i) {
            valueRepresentationArray[i] = ExpressionTool.lazyEvaluate(this.argument[i], xPathContext, 1);
        }
        try {
            return this.call(valueRepresentationArray, xPathContext);
        }
        catch (XPathException xPathException) {
            String string = xPathException.getMessage();
            string = "Error in call to extension function {" + this.theMethod.toString() + "}: " + string;
            DynamicError dynamicError = new DynamicError(string, xPathException.getException());
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setLocator(this);
            dynamicError.setErrorCode(xPathException.getErrorCodeLocalPart());
            throw dynamicError;
        }
    }

    public Class getTargetClass() {
        return this.theClass;
    }

    public AccessibleObject getTargetMethod() {
        return this.theMethod;
    }

    protected SequenceIterator call(ValueRepresentation[] valueRepresentationArray, XPathContext xPathContext) throws XPathException {
        if (this.theMethod instanceof Constructor) {
            Constructor constructor = (Constructor)this.theMethod;
            if (this.theParameterTypes == null) {
                this.theParameterTypes = constructor.getParameterTypes();
            }
            Object[] objectArray = new Object[this.theParameterTypes.length];
            this.setupParams(valueRepresentationArray, objectArray, this.theParameterTypes, 0, 0, xPathContext);
            try {
                Object object = this.invokeConstructor(constructor, objectArray);
                return this.asIterator(object, xPathContext);
            }
            catch (InstantiationException instantiationException) {
                DynamicError dynamicError = new DynamicError("Cannot instantiate class", instantiationException);
                throw dynamicError;
            }
            catch (IllegalAccessException illegalAccessException) {
                DynamicError dynamicError = new DynamicError("Constructor access is illegal", illegalAccessException);
                throw dynamicError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DynamicError dynamicError = new DynamicError("Argument is of wrong type", illegalArgumentException);
                throw dynamicError;
            }
            catch (NullPointerException nullPointerException) {
                DynamicError dynamicError = new DynamicError("Object is null");
                throw dynamicError;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof XPathException) {
                    throw (XPathException)throwable;
                }
                if (xPathContext.getController().isTracing() || xPathContext.getConfiguration().isTraceExternalFunctions()) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                DynamicError dynamicError = new DynamicError("Exception in extension function: " + invocationTargetException.getTargetException().toString(), throwable);
                throw dynamicError;
            }
        }
        if (this.theMethod instanceof Method) {
            Object object;
            Object object2;
            boolean bl;
            Method method = (Method)this.theMethod;
            boolean bl2 = Modifier.isStatic(method.getModifiers());
            if (this.theParameterTypes == null) {
                this.theParameterTypes = method.getParameterTypes();
            }
            boolean bl3 = this.theParameterTypes.length > 0 && this.theParameterTypes[0] == XPathContext.class ? true : (bl = false);
            if (bl2) {
                object2 = null;
            } else {
                if (valueRepresentationArray.length == 0) {
                    DynamicError dynamicError = new DynamicError("Must supply an argument for an instance-level extension function");
                    throw dynamicError;
                }
                object = Value.asValue(valueRepresentationArray[0]);
                object2 = ((Value)object).convertToJava(this.theClass, xPathContext);
            }
            object = new Object[this.theParameterTypes.length];
            if (bl) {
                object[0] = xPathContext;
            }
            this.setupParams(valueRepresentationArray, (Object[])object, this.theParameterTypes, bl ? 1 : 0, bl2 ? 0 : 1, xPathContext);
            try {
                Object object3 = this.invokeMethod(method, object2, (Object[])object);
                if (method.getReturnType() == Void.TYPE) {
                    return EmptyIterator.getInstance();
                }
                return this.asIterator(object3, xPathContext);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DynamicError("Method access is illegal", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DynamicError("Argument is of wrong type", illegalArgumentException);
            }
            catch (NullPointerException nullPointerException) {
                throw new DynamicError("Object is null", nullPointerException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof XPathException) {
                    throw (XPathException)throwable;
                }
                if (xPathContext.getController().isTracing() || xPathContext.getConfiguration().isTraceExternalFunctions()) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                throw new DynamicError("Exception in extension function " + invocationTargetException.getTargetException().toString(), throwable);
            }
        }
        if (this.theMethod instanceof Field) {
            Object object;
            Object object4;
            Field field = (Field)this.theMethod;
            boolean bl = Modifier.isStatic(field.getModifiers());
            if (bl) {
                object4 = null;
            } else {
                if (valueRepresentationArray.length == 0) {
                    DynamicError dynamicError = new DynamicError("Must supply an argument for an instance-level extension function");
                    throw dynamicError;
                }
                object = Value.asValue(valueRepresentationArray[0]);
                object4 = ((Value)object).convertToJava(this.theClass, xPathContext);
            }
            try {
                object = this.getField(field, object4);
                return this.asIterator(object, xPathContext);
            }
            catch (IllegalAccessException illegalAccessException) {
                DynamicError dynamicError = new DynamicError("Field access is illegal", illegalAccessException);
                throw dynamicError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DynamicError dynamicError = new DynamicError("Argument is of wrong type", illegalArgumentException);
                throw dynamicError;
            }
        }
        throw new AssertionError((Object)("property " + this.theMethod + " is neither constructor, method, nor field"));
    }

    private SequenceIterator asIterator(Object object, XPathContext xPathContext) throws XPathException {
        if (object == null) {
            return EmptyIterator.getInstance();
        }
        if (object instanceof SequenceIterator) {
            return (SequenceIterator)object;
        }
        if (object instanceof Value) {
            return ((Value)object).iterate();
        }
        if (object instanceof NodeInfo) {
            return SingletonIterator.makeIterator((NodeInfo)object);
        }
        Value value = Value.convertJavaObjectToXPath(object, SequenceType.ANY_SEQUENCE, xPathContext);
        return value.iterate();
    }

    private void setupParams(ValueRepresentation[] valueRepresentationArray, Object[] objectArray, Class[] classArray, int n, int n2, XPathContext xPathContext) throws XPathException {
        int n3 = n;
        for (int i = n2; i < valueRepresentationArray.length; ++i) {
            valueRepresentationArray[i] = Value.asValue(valueRepresentationArray[i]);
            objectArray[n3] = ((Value)valueRepresentationArray[i]).convertToJava(classArray[n3], xPathContext);
            ++n3;
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.convertClassToType(this.getReturnClass());
    }

    private ItemType convertClassToType(Class clazz) {
        if (clazz == null || clazz == Value.class) {
            return AnyItemType.getInstance();
        }
        if (clazz.toString().equals("void")) {
            return AnyItemType.getInstance();
        }
        if (clazz == String.class || clazz == StringValue.class) {
            return BuiltInAtomicType.STRING;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE || clazz == BooleanValue.class) {
            return BuiltInAtomicType.BOOLEAN;
        }
        if (clazz == Double.class || clazz == Double.TYPE || clazz == DoubleValue.class) {
            return BuiltInAtomicType.DOUBLE;
        }
        if (clazz == Float.class || clazz == Float.TYPE || clazz == FloatValue.class) {
            return BuiltInAtomicType.FLOAT;
        }
        if (clazz == Long.class || clazz == Long.TYPE || clazz == Int64Value.class || clazz == BigIntegerValue.class || clazz == Integer.class || clazz == Integer.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Byte.class || clazz == Byte.TYPE) {
            return BuiltInAtomicType.INTEGER;
        }
        if (clazz == BigDecimal.class) {
            return BuiltInAtomicType.DECIMAL;
        }
        if (clazz == Date.class) {
            return BuiltInAtomicType.DATE_TIME;
        }
        if (Value.class.isAssignableFrom(clazz) || SequenceIterator.class.isAssignableFrom(clazz)) {
            return AnyItemType.getInstance();
        }
        Object object = this.config.getExternalObjectModels();
        for (int i = 0; i < object.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)object.get(i);
            if (!externalObjectModel.isRecognizedNodeClass(clazz) && !externalObjectModel.isRecognizedNodeListClass(clazz)) continue;
            return AnyNodeTest.getInstance();
        }
        if (NodeInfo.class.isAssignableFrom(clazz) || Source.class.isAssignableFrom(clazz)) {
            return AnyNodeTest.getInstance();
        }
        if (List.class.isAssignableFrom(clazz)) {
            return AnyItemType.getInstance();
        }
        if (clazz.isArray()) {
            object = clazz.getComponentType();
            return this.convertClassToType((Class)object);
        }
        return new ExternalObjectType(clazz, this.config);
    }

    public int computeCardinality() {
        Class clazz = this.getReturnClass();
        if (clazz == null) {
            return 57344;
        }
        if (Value.class.isAssignableFrom(clazz) || SequenceIterator.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz) || Closure.class.isAssignableFrom(clazz) || Source.class.isAssignableFrom(clazz) || clazz.isArray()) {
            return 57344;
        }
        List list = this.config.getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
            if (externalObjectModel.isRecognizedNodeClass(clazz)) {
                return 24576;
            }
            if (!externalObjectModel.isRecognizedNodeListClass(clazz)) continue;
            return 57344;
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Void.TYPE)) {
                return 24576;
            }
            return 16384;
        }
        return 24576;
    }

    private Class getReturnClass() {
        if (this.theMethod instanceof Method) {
            return ((Method)this.theMethod).getReturnType();
        }
        if (this.theMethod instanceof Field) {
            return ((Field)this.theMethod).getType();
        }
        if (this.theMethod instanceof Constructor) {
            return this.theClass;
        }
        return null;
    }

    public boolean usesFocus() {
        if (this.theMethod instanceof Method) {
            Class<?>[] classArray = ((Method)this.theMethod).getParameterTypes();
            return classArray.length > 0 && classArray[0] == XPathContext.class;
        }
        return false;
    }

    protected Object invokeConstructor(Constructor constructor, Object[] objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return constructor.newInstance(objectArray);
    }

    protected Object invokeMethod(Method method, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(object, objectArray);
    }

    protected Object getField(Field field, Object object) throws IllegalAccessException {
        return field.get(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.persistentMethod = new MethodRepresentation(this.theClass, this.theMethod);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.theMethod = this.persistentMethod.recoverAccessibleObject();
            this.theParameterTypes = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Cannot load a class containing extension functions used by the stylesheet: " + classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            throw new IOException("Failed to read compiled representation of extension function call to " + (this.theClass == null ? "*unknown class*" : this.theClass.getClass().getName()) + ": " + exception.getMessage());
        }
    }

    public static String toCamelCase(String string, boolean bl, PrintStream printStream) {
        if (string.indexOf(45) >= 0) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length());
            boolean bl2 = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '-') {
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    fastStringBuffer.append(Character.toUpperCase(c));
                } else {
                    fastStringBuffer.append(c);
                }
                bl2 = false;
            }
            string = fastStringBuffer.toString();
            if (bl) {
                printStream.println("Seeking a method with adjusted name " + string);
            }
        }
        return string;
    }

    private static class MethodRepresentation
    implements Serializable {
        private Class theClass;
        private byte category;
        private String name;
        private Class[] params;

        public MethodRepresentation(Class clazz, AccessibleObject accessibleObject) {
            this.theClass = clazz;
            if (accessibleObject instanceof Method) {
                this.category = 0;
                this.name = ((Method)accessibleObject).getName();
                this.params = ((Method)accessibleObject).getParameterTypes();
            } else if (accessibleObject instanceof Constructor) {
                this.category = 1;
                this.params = ((Constructor)accessibleObject).getParameterTypes();
            } else {
                this.category = (byte)2;
                this.name = ((Field)accessibleObject).getName();
            }
        }

        public AccessibleObject recoverAccessibleObject() throws NoSuchMethodException, NoSuchFieldException {
            switch (this.category) {
                case 0: {
                    return this.theClass.getMethod(this.name, this.params);
                }
                case 1: {
                    return this.theClass.getConstructor(this.params);
                }
                case 2: {
                    return this.theClass.getField(this.name);
                }
            }
            return null;
        }
    }
}

