/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public final class LocalParam
extends GeneralVariable {
    private Expression conversion = null;
    private int conversionEvaluationMode = -1;

    public void setConversion(Expression expression) {
        this.conversion = expression;
        if (expression != null) {
            Expression.setParentExpression(expression, this);
            this.conversionEvaluationMode = ExpressionTool.eagerEvaluationMode(this.conversion);
        }
    }

    public int getInstructionNameCode() {
        return 170;
    }

    public Iterator iterateSubExpressions() {
        if (this.select != null && this.conversion != null) {
            return new PairIterator(this.select, this.conversion);
        }
        if (this.select != null) {
            return new MonoIterator(this.select);
        }
        if (this.conversion != null) {
            return new MonoIterator(this.conversion);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        if (this.conversion == expression) {
            this.conversion = expression2;
            bl = true;
        }
        return bl;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        boolean bl = xPathContext.useLocalParameter(this.getVariableFingerprint(), this, this.isTunnelParam());
        if (bl) {
            if (this.conversion != null) {
                xPathContext.setLocalVariable(this.getSlotNumber(), ExpressionTool.evaluate(this.conversion, this.conversionEvaluationMode, xPathContext, 10));
            }
        } else {
            if (this.isImplicitlyRequiredParam()) {
                DynamicError dynamicError = new DynamicError("A value must be supplied for the parameter because the default value is not a valid instance of the required type");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XTDE0610");
                throw dynamicError;
            }
            if (this.isRequiredParam()) {
                DynamicError dynamicError = new DynamicError("No value supplied for required parameter");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XTDE0700");
                throw dynamicError;
            }
            xPathContext.setLocalVariable(this.getSlotNumber(), this.getSelectValue(xPathContext));
        }
        return null;
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) {
        return xPathContext.evaluateLocalVariable(this.slotNumber);
    }
}

