/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;

public final class XSLSequence
extends StyleElement {
    private Expression select;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        return this.select.getItemType(typeHierarchy);
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public boolean mayContainFallback() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string2 = this.getNamePool().getClarkName(n);
            if (string2 == "select") {
                string = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        } else {
            this.reportAbsence("select");
            this.select = Literal.makeLiteral(EmptySequence.getInstance());
        }
    }

    public void validate() throws XPathException {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLFallback) continue;
            this.compileError("The only child node allowed for xsl:sequence is an xsl:fallback instruction", "XTSE0010");
            break;
        }
        this.select = this.typeCheck("select", this.select);
    }

    public void markTailCalls(int n, int n2) {
        StyleElement styleElement = this.getLastChildInstruction();
        if (styleElement != null) {
            styleElement.markTailCalls();
        } else if (this.select != null) {
            ExpressionTool.markTailFunctionCalls(this.select, n, n2);
        }
    }

    public Expression compile(Executable executable) {
        return this.select;
    }
}

