/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.QNameValue;

public class XPathEvaluator {
    private XPathStaticContext staticContext;
    private boolean stripSpace = false;

    public XPathEvaluator() {
        this(new Configuration());
    }

    public XPathEvaluator(Configuration configuration) {
        this.staticContext = new IndependentContext(configuration);
    }

    public Configuration getConfiguration() {
        return this.staticContext.getConfiguration();
    }

    public void setStripSpace(boolean bl) {
        this.stripSpace = bl;
    }

    public NodeInfo build(Source source) throws XPathException {
        if (this.stripSpace) {
            AugmentedSource augmentedSource = AugmentedSource.makeAugmentedSource(source);
            augmentedSource.setStripSpace(12);
            source = augmentedSource;
        }
        return this.getConfiguration().buildDocument(source);
    }

    public XPathVariable declareVariable(String string, String string2) {
        return this.staticContext.declareVariable(new QNameValue("", string, string2));
    }

    public void setStaticContext(XPathStaticContext xPathStaticContext) {
        this.staticContext = xPathStaticContext;
    }

    public XPathStaticContext getStaticContext() {
        return this.staticContext;
    }

    public Executable getExecutable() {
        return this.staticContext.getExecutable();
    }

    public XPathExpression createExpression(String string) throws XPathException {
        Expression expression = ExpressionTool.make(string, this.staticContext, 0, -1, 1, false);
        expression.setParentExpression(this.staticContext);
        expression = expression.typeCheck(this.staticContext, Type.ITEM_TYPE);
        SlotManager slotManager = this.staticContext.getStackFrameMap();
        int n = slotManager.getNumberOfVariables();
        ExpressionTool.allocateSlots(expression, n, slotManager);
        XPathExpression xPathExpression = new XPathExpression(this, expression);
        xPathExpression.setStackFrameMap(slotManager, n);
        return xPathExpression;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.staticContext.setNamespaceResolver(namespaceResolver);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.staticContext.getNamespaceResolver();
    }

    public void setDefaultElementNamespace(String string) {
        this.staticContext.setDefaultElementNamespace(string);
    }

    public static void main(String[] stringArray) throws Exception {
        Item item;
        XPathEvaluator xPathEvaluator = new XPathEvaluator();
        XPathVariable xPathVariable = xPathEvaluator.declareVariable("", "in");
        XPathExpression xPathExpression = xPathEvaluator.createExpression("for $v in distinct-values(tokenize($in, '/')) return concat(' +', $v)");
        DocumentInfo documentInfo = xPathEvaluator.getConfiguration().buildDocument(new StreamSource(new File(stringArray[0])));
        XPathDynamicContext xPathDynamicContext = xPathExpression.createDynamicContext(documentInfo);
        SequenceIterator sequenceIterator = xPathExpression.iterate(xPathDynamicContext);
        while ((item = sequenceIterator.next()) != null) {
            System.err.println(item);
        }
    }
}

