/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.value.Value;

abstract class TreeEnumeration
implements AxisIterator,
LookaheadIterator {
    protected NodeImpl start;
    protected NodeImpl next;
    protected NodeTest nodeTest;
    protected NodeImpl current = null;
    protected int position = 0;

    public TreeEnumeration(NodeImpl nodeImpl, NodeTest nodeTest) {
        this.next = nodeImpl;
        this.start = nodeImpl;
        this.nodeTest = nodeTest;
    }

    protected boolean conforms(NodeImpl nodeImpl) {
        if (nodeImpl == null || this.nodeTest == null) {
            return true;
        }
        return this.nodeTest.matches(nodeImpl);
    }

    protected final void advance() {
        do {
            this.step();
        } while (!this.conforms(this.next));
    }

    protected abstract void step();

    public boolean hasNext() {
        return this.next != null;
    }

    public boolean moveNext() {
        return this.next() != null;
    }

    public final Item next() {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    public final Item current() {
        return this.current;
    }

    public final int position() {
        return this.position;
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        return this.current.iterateAxis(by, nodeTest);
    }

    public Value atomize() throws XPathException {
        return this.current.atomize();
    }

    public CharSequence getStringValue() {
        return this.current.getStringValueCS();
    }

    public int getProperties() {
        return 4;
    }
}

