/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import java.util.HashMap;
import java.util.Map;

public enum StreamStatus {
    PROTOCOL_ERROR(1, 1),
    INVALID_STREAM(2, 2),
    REFUSED_STREAM(3, 3),
    UNSUPPORTED_VERSION(4, 4),
    CANCEL_STREAM(5, 5),
    INTERNAL_ERROR(6, 6),
    FLOW_CONTROL_ERROR(7, 7),
    STREAM_IN_USE(-1, 8),
    STREAM_ALREADY_CLOSED(-1, 9),
    INVALID_CREDENTIALS(-1, 10),
    FRAME_TOO_LARGE(-1, 11);

    private final int v2Code;
    private final int v3Code;

    public static StreamStatus from(short version, int code) {
        switch (version) {
            case 2: {
                return (StreamStatus)((Object)Codes.v2Codes.get(code));
            }
            case 3: {
                return (StreamStatus)((Object)Codes.v3Codes.get(code));
            }
        }
        throw new IllegalStateException();
    }

    private StreamStatus(int v2Code, int v3Code) {
        this.v2Code = v2Code;
        if (v2Code >= 0) {
            Codes.v2Codes.put(v2Code, this);
        }
        this.v3Code = v3Code;
        if (v3Code >= 0) {
            Codes.v3Codes.put(v3Code, this);
        }
    }

    public int getCode(short version) {
        switch (version) {
            case 2: {
                return this.v2Code;
            }
            case 3: {
                return this.v3Code;
            }
        }
        throw new IllegalStateException();
    }

    private static class Codes {
        private static final Map<Integer, StreamStatus> v2Codes = new HashMap<Integer, StreamStatus>();
        private static final Map<Integer, StreamStatus> v3Codes = new HashMap<Integer, StreamStatus>();

        private Codes() {
        }
    }
}

