/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import java.util.EnumMap;
import org.eclipse.jetty.spdy.CompressionFactory;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.CredentialBodyParser;
import org.eclipse.jetty.spdy.parser.GoAwayBodyParser;
import org.eclipse.jetty.spdy.parser.HeadersBodyParser;
import org.eclipse.jetty.spdy.parser.NoOpBodyParser;
import org.eclipse.jetty.spdy.parser.PingBodyParser;
import org.eclipse.jetty.spdy.parser.RstStreamBodyParser;
import org.eclipse.jetty.spdy.parser.SettingsBodyParser;
import org.eclipse.jetty.spdy.parser.SynReplyBodyParser;
import org.eclipse.jetty.spdy.parser.SynStreamBodyParser;
import org.eclipse.jetty.spdy.parser.UnknownControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.WindowUpdateBodyParser;

public abstract class ControlFrameParser {
    private final EnumMap<ControlFrameType, ControlFrameBodyParser> parsers = new EnumMap(ControlFrameType.class);
    private final ControlFrameBodyParser unknownParser = new UnknownControlFrameBodyParser(this);
    private State state = State.VERSION;
    private int cursor;
    private short version;
    private short type;
    private byte flags;
    private int length;
    private ControlFrameBodyParser bodyParser;
    private int bytesToSkip = 0;

    public ControlFrameParser(CompressionFactory.Decompressor decompressor) {
        this.parsers.put(ControlFrameType.SYN_STREAM, new SynStreamBodyParser(decompressor, this));
        this.parsers.put(ControlFrameType.SYN_REPLY, new SynReplyBodyParser(decompressor, this));
        this.parsers.put(ControlFrameType.RST_STREAM, new RstStreamBodyParser(this));
        this.parsers.put(ControlFrameType.SETTINGS, new SettingsBodyParser(this));
        this.parsers.put(ControlFrameType.NOOP, new NoOpBodyParser(this));
        this.parsers.put(ControlFrameType.PING, new PingBodyParser(this));
        this.parsers.put(ControlFrameType.GO_AWAY, new GoAwayBodyParser(this));
        this.parsers.put(ControlFrameType.HEADERS, new HeadersBodyParser(decompressor, this));
        this.parsers.put(ControlFrameType.WINDOW_UPDATE, new WindowUpdateBodyParser(this));
        this.parsers.put(ControlFrameType.CREDENTIAL, new CredentialBodyParser(this));
    }

    public short getVersion() {
        return this.version;
    }

    public byte getFlags() {
        return this.flags;
    }

    public int getLength() {
        return this.length;
    }

    public void skip(int bytesToSkip) {
        this.state = State.SKIP;
        this.bytesToSkip = bytesToSkip;
    }

    public boolean parse(ByteBuffer buffer) {
        block10: while (buffer.hasRemaining()) {
            switch (this.state) {
                case VERSION: {
                    if (buffer.remaining() >= 2) {
                        this.version = (short)(buffer.getShort() & Short.MAX_VALUE);
                        this.state = State.TYPE;
                        continue block10;
                    }
                    this.state = State.VERSION_BYTES;
                    this.cursor = 2;
                    continue block10;
                }
                case VERSION_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.version = (short)(this.version + ((currByte & 0xFF) << 8 * this.cursor));
                    if (this.cursor != 0) continue block10;
                    this.version = (short)(this.version & Short.MAX_VALUE);
                    this.state = State.TYPE;
                    continue block10;
                }
                case TYPE: {
                    if (buffer.remaining() >= 2) {
                        this.type = buffer.getShort();
                        this.state = State.FLAGS;
                        continue block10;
                    }
                    this.state = State.TYPE_BYTES;
                    this.cursor = 2;
                    continue block10;
                }
                case TYPE_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.type = (short)(this.type + ((currByte & 0xFF) << 8 * this.cursor));
                    if (this.cursor != 0) continue block10;
                    this.state = State.FLAGS;
                    continue block10;
                }
                case FLAGS: {
                    this.flags = buffer.get();
                    this.cursor = 3;
                    this.state = State.LENGTH;
                    continue block10;
                }
                case LENGTH: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.length += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor > 0) continue block10;
                    ControlFrameType controlFrameType = ControlFrameType.from(this.type);
                    this.bodyParser = controlFrameType == null ? this.unknownParser : this.parsers.get((Object)controlFrameType);
                    this.state = State.BODY;
                }
                case BODY: {
                    if (!this.bodyParser.parse(buffer)) continue block10;
                    this.reset();
                    return true;
                }
                case SKIP: {
                    int remaining = buffer.remaining();
                    if (remaining >= this.bytesToSkip) {
                        buffer.position(buffer.position() + this.bytesToSkip);
                        this.reset();
                        return true;
                    }
                    buffer.position(buffer.limit());
                    this.bytesToSkip -= remaining;
                    return false;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    void reset() {
        this.state = State.VERSION;
        this.cursor = 0;
        this.version = 0;
        this.type = 0;
        this.flags = 0;
        this.length = 0;
        this.bodyParser = null;
        this.bytesToSkip = 0;
    }

    protected abstract void onControlFrame(ControlFrame var1);

    private static enum State {
        VERSION,
        VERSION_BYTES,
        TYPE,
        TYPE_BYTES,
        FLAGS,
        LENGTH,
        BODY,
        SKIP;

    }
}

