/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.fragment;

import java.nio.ByteBuffer;
import java.util.Queue;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public class FragmentExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(FragmentExtension.class);
    private final Queue<FrameEntry> entries = new ConcurrentArrayQueue<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private int maxLength;

    @Override
    public String getName() {
        return "fragment";
    }

    @Override
    public void incomingFrame(Frame frame) {
        this.nextIncomingFrame(frame);
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        int length;
        ByteBuffer payload = frame.getPayload();
        int n = length = payload != null ? payload.remaining() : 0;
        if (OpCode.isControlFrame(frame.getOpCode()) || this.maxLength <= 0 || length <= this.maxLength) {
            this.nextOutgoingFrame(frame, callback, batchMode);
            return;
        }
        FrameEntry entry = new FrameEntry(frame, callback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", entry);
        }
        this.entries.offer(entry);
        this.flusher.iterate();
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        this.maxLength = config.getParameter("maxLength", -1);
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (this.finished) {
                this.current = (FrameEntry)FragmentExtension.this.entries.poll();
                LOG.debug("Processing {}", this.current);
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.fragment(this.current, true);
            } else {
                this.fragment(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void fragment(FrameEntry entry, boolean first) {
            Frame frame = entry.frame;
            ByteBuffer payload = frame.getPayload();
            int remaining = payload.remaining();
            int length = Math.min(remaining, FragmentExtension.this.maxLength);
            this.finished = length == remaining;
            boolean continuation = frame.getType().isContinuation() || !first;
            DataFrame fragment = new DataFrame(frame, continuation);
            boolean fin = frame.isFin() && this.finished;
            fragment.setFin(fin);
            int limit = payload.limit();
            int newLimit = payload.position() + length;
            payload.limit(newLimit);
            ByteBuffer payloadFragment = payload.slice();
            payload.limit(limit);
            fragment.setPayload(payloadFragment);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fragmented {}->{}", frame, fragment);
            }
            payload.position(newLimit);
            FragmentExtension.this.nextOutgoingFrame(fragment, this, entry.batchMode);
        }

        @Override
        protected void onCompleteSuccess() {
        }

        @Override
        protected void onCompleteFailure(Throwable x) {
        }

        @Override
        public void writeSuccess() {
            this.notifyCallbackSuccess(this.current.callback);
            this.succeeded();
        }

        @Override
        public void writeFailed(Throwable x) {
            this.notifyCallbackFailure(this.current.callback, x);
            this.succeeded();
        }

        private void notifyCallbackSuccess(WriteCallback callback) {
            block3: {
                try {
                    if (callback != null) {
                        callback.writeSuccess();
                    }
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying success of callback " + callback, x);
                }
            }
        }

        private void notifyCallbackFailure(WriteCallback callback, Throwable failure) {
            block3: {
                try {
                    if (callback != null) {
                        callback.writeFailed(failure);
                    }
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying failure of callback " + callback, x);
                }
            }
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback callback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = callback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

