/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.text.MessageFormat;
import org.apache.uima.taeconfigurator.CDEpropertyPage;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class AddRemoteServiceDialog
extends AbstractDialog {
    private String m_selectedServiceTypeName = null;
    private String m_selectedUri = null;
    private String m_selectedKey = null;
    private boolean m_bAutoAddToFlow;
    public String vnsPort;
    public String vnsHost;
    public String timeout;
    public String aeOrCc;
    private CCombo serviceTypeCombo;
    private Text uriText;
    private Text endpointText;
    private Text keyText;
    private Text timeoutText;
    private Button autoAddToFlowButton;
    private Button importByNameUI;
    private Button importByLocationUI;
    public boolean isImportByName;
    private String rootPath;
    private DialogModifyListener m_dialogModifyListener = new DialogModifyListener();
    private Text genFilePathUI;
    public String genFilePath;
    private String keyTextPrev;
    private Label vnsHostLabel;
    private Text vnsHostUI;
    private Label vnsPortLabel;
    private Text vnsPortUI;
    private boolean portNumberWasBad;
    private boolean portNumberIsOK;
    private CCombo aeOrCcCombo;
    private Label endpointLabel;
    private Label uriLabel;
    private Label timeoutProcessLabel;
    private Label timeoutJmsGetmetaLabel;
    private Text timeoutGetmetaText;
    public String getmetaTimeout;
    public String endpoint;
    private Text timeoutJmsCpcText;
    private Label timeoutJmsCpcLabel;
    private Label binarySerializationLabel;
    private CCombo binarySerializationCombo;
    private Label ignoreProcessErrorsLabel;
    private CCombo ignoreProcessErrorsCombo;
    public String cpcTimeout;
    public String binary_serialization;
    public String ignore_process_errors;

    public AddRemoteServiceDialog(AbstractSection aSection, String aRootPath) {
        super(aSection, "Add Remote Service", "Fill in the information about the remote service and press OK");
        this.rootPath = aRootPath;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite tc1 = this.new2ColumnComposite(composite);
        Label tempLabel = new Label(tc1, 64);
        this.setTextAndTip(tempLabel, "Service kind:", "", 1, false);
        this.aeOrCcCombo = this.wideCCombo(tc1, "Specify whether the Service is an Analysis Engine or a Cas Consumer", "AnalysisEngine", "CasConsumer");
        tempLabel = new Label(tc1, 64);
        this.setTextAndTip(tempLabel, "Protocol Service Type", "", 1, false);
        this.serviceTypeCombo = this.wideCCombo(tc1, "", "UIMA-AS JMS", "SOAP", "Vinci");
        this.uriLabel = new Label(tc1, 0);
        this.setTextAndTip(this.uriLabel, "URI of service or JMS Broker:", "The URI for the service, e.g. localhost", 1, false);
        this.uriText = this.wideTextInput(tc1, "", this.m_dialogModifyListener);
        this.endpointLabel = new Label(tc1, 0);
        this.setTextAndTip(this.endpointLabel, "Endpoint Name (JMS Service):", "For UIMA-AS JMS Services only, the endpoint name", 1, false);
        this.endpointText = this.wideTextInput(tc1, "", this.m_dialogModifyListener);
        this.binarySerializationLabel = new Label(tc1, 0);
        this.setTextAndTip(this.binarySerializationLabel, "Binary Serialization (JMS Service):", "For UIMA-AS JMS Services only, use binary serialzation (requires all type systems be identical)", 1, false);
        this.binarySerializationCombo = this.wideCComboTF(tc1, "");
        this.ignoreProcessErrorsLabel = new Label(tc1, 0);
        this.setTextAndTip(this.ignoreProcessErrorsLabel, "Ignore Process Errors (JMS Service):", "For UIMA-AS JMS Services only, ignore processing errors");
        this.ignoreProcessErrorsLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.ignoreProcessErrorsCombo = this.wideCComboTF(tc1, "");
        tempLabel = new Label(tc1, 0);
        this.setTextAndTip(tempLabel, "Key (a short mnemonic for this service):", "also used as part of the file name", 1, false);
        this.keyText = this.wideTextInput(tc1, "", this.m_dialogModifyListener);
        this.keyText.addVerifyListener((VerifyListener)new DialogVerifyListener());
        this.keyTextPrev = ".xml";
        this.createWideLabel(composite, "Where the generated remote descriptor file will be stored:");
        this.genFilePathUI = new Text(composite, 2304);
        this.genFilePathUI.setLayoutData((Object)new GridData(768));
        this.genFilePathUI.setText(this.rootPath + ".xml");
        this.createWideLabel(composite, "Timeouts, in milliseconds.  This is ignored for the Vinci protocol.  Specify 0 to wait forever. If not specified, a default timeout is used.");
        tc1 = this.new2ColumnComposite(composite);
        this.timeoutProcessLabel = new Label(tc1, 0);
        this.setTextAndTip(this.timeoutProcessLabel, "Timeout: Process:", "Timeout for processing a CAS", 1, false);
        this.timeoutText = this.wideTextInput(tc1, "");
        this.timeoutJmsGetmetaLabel = new Label(tc1, 0);
        this.setTextAndTip(this.timeoutJmsGetmetaLabel, "Timeout: (JMS) GetMeta:", "Timeout for querying the metadata from a JMS service", 1, false);
        this.timeoutGetmetaText = this.wideTextInput(tc1, "");
        this.timeoutJmsCpcLabel = new Label(tc1, 0);
        this.setTextAndTip(this.timeoutJmsCpcLabel, "Timeout: (JMS) Collection Processing Complete:", "Timeout for Collection Processing Complete", 1, false);
        this.timeoutJmsCpcText = this.wideTextInput(tc1, "");
        this.createWideLabel(composite, "For the Vinci protocol, you can optionally specify the Host/Port for the Vinci Name Service");
        Composite tc = this.new2ColumnComposite(composite);
        this.vnsHostLabel = new Label(tc, 0);
        this.setTextAndTip(this.vnsHostLabel, "VNS HOST", "An IP name or address, e.g. localhost");
        this.vnsHostUI = this.newText(tc, 0, "An IP name or address, e.g. localhost");
        this.vnsPortLabel = new Label(tc, 0);
        this.setTextAndTip(this.vnsPortLabel, "VNS PORT", "A port number, e.g. 9000");
        this.vnsPortUI = this.newText(tc, 0, "A port number, e.g. 9000");
        this.newErrorMessage(composite);
        this.autoAddToFlowButton = new Button(composite, 32);
        this.autoAddToFlowButton.setText("Add to end of flow");
        this.autoAddToFlowButton.setSelection(true);
        new Label(composite, 0).setText("");
        this.importByNameUI = new Button(composite, 16);
        this.importByNameUI.setText("Import by Name");
        this.importByNameUI.setToolTipText("Importing by name looks up the name on the classpath and datapath.");
        this.importByNameUI.setSelection(true);
        this.importByLocationUI = new Button(composite, 16);
        this.importByLocationUI.setText("Import By Location");
        this.importByLocationUI.setToolTipText("Importing by location requires a relative or absolute URL");
        String defaultBy = CDEpropertyPage.getImportByDefault(this.editor.getProject());
        if (defaultBy.equals("location")) {
            this.importByNameUI.setSelection(false);
            this.importByLocationUI.setSelection(true);
        } else {
            this.importByNameUI.setSelection(true);
            this.importByLocationUI.setSelection(false);
        }
        return composite;
    }

    private CCombo wideCCombo(Composite tc, String tip, String ... entries) {
        CCombo cc = this.newCCombo(tc, tip);
        for (String e : entries) {
            cc.add(e);
        }
        ((GridData)cc.getLayoutData()).grabExcessHorizontalSpace = true;
        cc.select(0);
        return cc;
    }

    private CCombo wideCComboTF(Composite tc, String tip) {
        return this.wideCCombo(tc, tip, "false", "true");
    }

    private Text wideTextInput(Composite tc, String tip) {
        return this.wideTextInput(tc, tip, null);
    }

    private Text wideTextInput(Composite tc, String tip, DialogModifyListener listener) {
        Text t = this.newText(tc, 2048, tip);
        t.setLayoutData((Object)new GridData(4, 1, true, false));
        if (listener != null) {
            t.addModifyListener((ModifyListener)listener);
        } else {
            t.setEnabled(false);
        }
        return t;
    }

    @Override
    public void enableOK() {
        boolean bEnableOk;
        boolean isVinci = this.serviceTypeCombo.getSelectionIndex() == 2;
        boolean isJms = this.serviceTypeCombo.getSelectionIndex() == 0;
        this.vnsHostLabel.setEnabled(isVinci);
        this.vnsHostUI.setEnabled(isVinci);
        this.vnsPortLabel.setEnabled(isVinci);
        this.vnsPortUI.setEnabled(isVinci);
        this.timeoutText.setEnabled(!isVinci);
        this.timeoutProcessLabel.setEnabled(!isVinci);
        this.timeoutJmsGetmetaLabel.setEnabled(isJms);
        this.timeoutGetmetaText.setEnabled(isJms);
        this.endpointLabel.setEnabled(isJms);
        this.endpointText.setEnabled(isJms);
        this.timeoutJmsCpcLabel.setEnabled(isJms);
        this.timeoutJmsCpcText.setEnabled(isJms);
        this.binarySerializationLabel.setEnabled(isJms);
        this.binarySerializationCombo.setEnabled(isJms);
        this.binarySerializationCombo.setVisible(isJms);
        this.ignoreProcessErrorsLabel.setEnabled(isJms);
        this.ignoreProcessErrorsCombo.setEnabled(isJms);
        this.ignoreProcessErrorsCombo.setVisible(isJms);
        boolean bl = bEnableOk = this.serviceTypeCombo.getText() != null && !this.serviceTypeCombo.getText().equals("") && this.uriText != null && !this.uriText.getText().trim().equals("") && this.keyText != null && !this.keyText.getText().trim().equals("");
        if (!bEnableOk) {
            this.setErrorMessage("missing URI or key");
        }
        this.portNumberIsOK = true;
        if (isVinci && this.vnsPortUI.getText().length() > 0) {
            try {
                Integer.parseInt(this.vnsPortUI.getText());
            }
            catch (NumberFormatException e) {
                bEnableOk = false;
                this.portNumberWasBad = true;
                this.portNumberIsOK = false;
                this.setErrorMessage("Invalid number, please correct.");
            }
        }
        if (isJms && (this.endpointText.getText() == null || this.endpointText.getText().trim().equals(""))) {
            bEnableOk = false;
            this.setErrorMessage("missing JMS endpoint");
        }
        this.okButton.setEnabled(bEnableOk);
        if (bEnableOk) {
            this.setErrorMessage("");
            this.portNumberWasBad = false;
        }
    }

    public String getSelectedServiceTypeName() {
        return this.m_selectedServiceTypeName;
    }

    public String getSelectedUri() {
        return this.m_selectedUri;
    }

    public String getSelectedKey() {
        return this.m_selectedKey;
    }

    public boolean getAutoAddToFlow() {
        return this.m_bAutoAddToFlow;
    }

    @Override
    public void copyValuesFromGUI() {
        this.genFilePath = this.genFilePathUI.getText();
        this.isImportByName = this.importByNameUI.getSelection();
        this.m_selectedServiceTypeName = this.serviceTypeCombo.getText();
        this.aeOrCc = this.aeOrCcCombo.getText();
        this.m_selectedUri = this.uriText.getText();
        this.m_selectedKey = this.keyText.getText();
        this.m_bAutoAddToFlow = this.autoAddToFlowButton.getSelection();
        this.timeout = this.timeoutText.getText();
        this.vnsHost = this.vnsHostUI.getText();
        this.vnsPort = this.vnsPortUI.getText();
        CDEpropertyPage.setImportByDefault(this.editor.getProject(), this.isImportByName ? "name" : "location");
        this.getmetaTimeout = this.timeoutGetmetaText.getText();
        this.cpcTimeout = this.timeoutJmsCpcText.getText();
        this.endpoint = this.endpointText.getText();
        this.binary_serialization = this.binarySerializationCombo.getText();
        this.ignore_process_errors = this.ignoreProcessErrorsCombo.getText();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private class DialogVerifyListener
    implements VerifyListener {
        private DialogVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            if (0 <= e.text.indexOf(46)) {
                AddRemoteServiceDialog.this.setErrorMessage(MessageFormat.format("invalid character(s): ''{0}''", e.text));
                e.doit = false;
            } else {
                AddRemoteServiceDialog.this.setErrorMessage("");
            }
        }
    }

    private class DialogModifyListener
    implements ModifyListener {
        private DialogModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String text = AddRemoteServiceDialog.this.genFilePathUI.getText();
            int pos = text.lastIndexOf(AddRemoteServiceDialog.this.keyTextPrev);
            if (pos == -1) {
                pos = text.length();
            }
            AddRemoteServiceDialog.this.keyTextPrev = AddRemoteServiceDialog.this.keyText.getText() + ".xml";
            AddRemoteServiceDialog.this.genFilePathUI.setText(text.substring(0, pos) + AddRemoteServiceDialog.this.keyTextPrev);
            if (AddRemoteServiceDialog.this.okButton != null) {
                AddRemoteServiceDialog.this.enableOK();
            }
        }
    }
}

