/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.editview;

import java.util.List;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.Images;
import org.apache.uima.caseditor.core.TaeError;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.ArrayValue;
import org.apache.uima.caseditor.editor.CasEditorError;
import org.apache.uima.caseditor.editor.FeatureStructureSelection;
import org.apache.uima.caseditor.editor.FeatureValue;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasEditor;
import org.apache.uima.caseditor.editor.editview.CreateFeatureStructureDialog;
import org.apache.uima.caseditor.editor.editview.EditView;
import org.apache.uima.caseditor.editor.editview.FeatureColumnLabelProvider;
import org.apache.uima.caseditor.editor.editview.FeatureStructureContentProvider;
import org.apache.uima.caseditor.editor.editview.ValueColumnLabelProvider;
import org.apache.uima.caseditor.editor.editview.validator.CellEditorValidatorFacotory;
import org.apache.uima.caseditor.editor.util.FeatureStructureTransfer;
import org.apache.uima.caseditor.editor.util.Primitives;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.Page;

final class EditViewPage
extends Page
implements ISelectionListener {
    private TreeViewer viewer;
    private ICasDocument document;
    private ICasEditor editor;
    private PinAction pinAction;
    private final EditView editView;

    EditViewPage(EditView editView, ICasEditor editor, ICasDocument document) {
        if (editView == null || document == null) {
            throw new IllegalArgumentException("Parameters must not be null!");
        }
        this.editView = editView;
        this.editor = editor;
        this.document = document;
    }

    public void createControl(Composite parent) {
        Tree tree = new Tree(parent, 0);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer = new TreeViewer(tree);
        TreeViewerColumn featureColumn = new TreeViewerColumn(this.viewer, 16384);
        featureColumn.getColumn().setText("Feature");
        featureColumn.getColumn().setWidth(100);
        featureColumn.setLabelProvider((CellLabelProvider)new FeatureColumnLabelProvider());
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.viewer, 16384);
        valueColumn.getColumn().setText("Value");
        valueColumn.getColumn().setWidth(100);
        valueColumn.setLabelProvider((CellLabelProvider)new ValueColumnLabelProvider());
        valueColumn.setEditingSupport((EditingSupport)new ValueEditingSupport((ColumnViewer)this.viewer));
        FeatureStructureContentProvider contentProvider = new FeatureStructureContentProvider(this.document);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setInput(null);
        this.document.addChangeListener(contentProvider);
        Transfer[] typesDropSupport = new Transfer[]{FeatureStructureTransfer.getInstance()};
        this.viewer.addDropSupport(1, typesDropSupport, new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                for (TransferData transferData : event.dataTypes) {
                    if (!FeatureStructureTransfer.getInstance().isSupportedType(transferData)) continue;
                    event.currentDataType = transferData;
                    break;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = FeatureStructureTransfer.getInstance().isSupportedType(event.currentDataType) ? 1 : 0;
            }

            public void drop(DropTargetEvent event) {
                if (FeatureStructureTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.detail = 0;
                    Widget tableItem = event.item;
                    if (tableItem != null) {
                        if (tableItem.getData() instanceof FeatureValue) {
                            FeatureStructure dragFeatureStructure;
                            Type range;
                            FeatureValue value = (FeatureValue)tableItem.getData();
                            TypeSystem typeSystem = value.getFeatureStructure().getCAS().getTypeSystem();
                            if (typeSystem.subsumes(range = value.getFeature().getRange(), (dragFeatureStructure = (FeatureStructure)event.data).getType())) {
                                FeatureStructure target = value.getFeatureStructure();
                                target.setFeatureValue(value.getFeature(), dragFeatureStructure);
                                EditViewPage.this.document.update(target);
                                event.detail = 1;
                            }
                        } else if (tableItem.getData() instanceof ArrayValue) {
                            ArrayValue value = (ArrayValue)tableItem.getData();
                            if (value.getFeatureStructure() instanceof ArrayFS) {
                                ArrayFS array = (ArrayFS)value.getFeatureStructure();
                                array.set(value.slot(), (FeatureStructure)event.data);
                                EditViewPage.this.document.update((FeatureStructure)array);
                                event.detail = 1;
                            }
                        } else {
                            throw new CasEditorError("Unkown item type!");
                        }
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        DragSource source = new DragSource((Control)this.viewer.getTree(), 1);
        source.setTransfer(new Transfer[]{FeatureStructureTransfer.getInstance()});
        source.addDragListener(new DragSourceListener(){
            TreeItem dragSourceItem = null;

            public void dragStart(DragSourceEvent event) {
                event.doit = false;
                TreeItem[] selection = EditViewPage.this.viewer.getTree().getSelection();
                if (selection.length > 0) {
                    this.dragSourceItem = selection[0];
                    IAdaptable adaptable = (IAdaptable)this.dragSourceItem.getData();
                    if (adaptable.getAdapter(FeatureStructure.class) != null) {
                        event.doit = true;
                    }
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IAdaptable adaptable = (IAdaptable)this.dragSourceItem.getData();
                event.data = adaptable.getAdapter(FeatureStructure.class);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setActionBars(IActionBars actionBars) {
        this.pinAction = new PinAction();
        this.pinAction.setText("Pin");
        this.pinAction.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.PIN));
        actionBars.getToolBarManager().add((IAction)this.pinAction);
        CreateFeatureStructrueValue createAction = new CreateFeatureStructrueValue();
        createAction.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.ADD));
        actionBars.getToolBarManager().add((IAction)createAction);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)createAction);
        DeleteFeatureStructureValue deleteAction = new DeleteFeatureStructureValue();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)deleteAction);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)deleteAction);
        actionBars.getToolBarManager().add((IAction)ActionFactory.DELETE.create(this.getSite().getWorkbenchWindow()));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        FeatureStructureSelection fsSelection;
        if (this.getSite().getPage().getActiveEditor() == this.editor && selection instanceof IStructuredSelection && (fsSelection = new FeatureStructureSelection((IStructuredSelection)selection)).size() == 1 && !this.pinAction.isChecked() && this.editView != part) {
            this.viewer.setInput((Object)fsSelection.toList().get(0));
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    private static final class PinAction
    extends Action {
        PinAction() {
            super("PinAction", 2);
        }
    }

    private final class CreateFeatureStructrueValue
    extends BaseSelectionListenerAction {
        protected CreateFeatureStructrueValue() {
            super("Create");
            this.setEnabled(false);
        }

        FeatureStructure createFS(Type type, int arraySize) {
            BooleanArrayFS fs;
            if (type.isPrimitive()) {
                throw new IllegalArgumentException("Cannot create FS for primitive type!");
            }
            TypeSystem ts = EditViewPage.this.document.getCAS().getTypeSystem();
            if (type.isArray()) {
                switch (type.getName()) {
                    case "uima.cas.BooleanArray": {
                        fs = EditViewPage.this.document.getCAS().createBooleanArrayFS(arraySize);
                        break;
                    }
                    case "uima.cas.ByteArray": {
                        fs = EditViewPage.this.document.getCAS().createByteArrayFS(arraySize);
                        break;
                    }
                    case "uima.cas.ShortArray": {
                        fs = EditViewPage.this.document.getCAS().createShortArrayFS(arraySize);
                        break;
                    }
                    case "uima.cas.IntegerArray": {
                        fs = EditViewPage.this.document.getCAS().createIntArrayFS(arraySize);
                        break;
                    }
                    case "uima.cas.LongArray": {
                        fs = EditViewPage.this.document.getCAS().createLongArrayFS(arraySize);
                        break;
                    }
                    case "uima.cas.FloatArray": {
                        fs = EditViewPage.this.document.getCAS().createFloatArrayFS(arraySize);
                        break;
                    }
                    case "uima.cas.DoubleArray": {
                        fs = EditViewPage.this.document.getCAS().createDoubleArrayFS(arraySize);
                        break;
                    }
                    case "uima.cas.StringArray": {
                        fs = EditViewPage.this.document.getCAS().createStringArrayFS(arraySize);
                        break;
                    }
                    case "uima.cas.FSArray": {
                        fs = EditViewPage.this.document.getCAS().createArrayFS(arraySize);
                        break;
                    }
                    default: {
                        throw new CasEditorError("Unkown array type: " + type.getName() + "!");
                    }
                }
            } else if (ts.subsumes(ts.getType("uima.tcas.Annotation"), type)) {
                int begin = 0;
                int end = 0;
                if (EditViewPage.this.editor instanceof AnnotationEditor) {
                    Point selection = ((AnnotationEditor)EditViewPage.this.editor).getSelection();
                    begin = selection.x;
                    end = selection.y;
                }
                fs = EditViewPage.this.document.getCAS().createAnnotation(type, begin, end);
            } else if (!type.isArray()) {
                fs = EditViewPage.this.document.getCAS().createFS(type);
            } else {
                throw new TaeError("Unexpected error!");
            }
            return fs;
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)EditViewPage.this.viewer.getSelection();
            if (selection.getFirstElement() instanceof FeatureValue) {
                FeatureStructure newValue;
                FeatureValue featureValue = (FeatureValue)selection.getFirstElement();
                Type fsSuperType = featureValue.getFeature().getRange();
                if (!fsSuperType.isArray()) {
                    Type typeToCreate;
                    List subTypes = EditViewPage.this.document.getCAS().getTypeSystem().getProperlySubsumedTypes(fsSuperType);
                    int arraySize = -1;
                    if (subTypes.size() == 0) {
                        typeToCreate = fsSuperType;
                    } else {
                        CreateFeatureStructureDialog createFsDialog = new CreateFeatureStructureDialog(Display.getCurrent().getActiveShell(), fsSuperType, EditViewPage.this.document.getCAS().getTypeSystem());
                        int returnCode = createFsDialog.open();
                        if (returnCode == 0) {
                            typeToCreate = createFsDialog.getType();
                            arraySize = createFsDialog.getArraySize();
                        } else {
                            return;
                        }
                    }
                    newValue = this.createFS(typeToCreate, arraySize);
                    EditViewPage.this.document.addFeatureStructure(newValue);
                } else {
                    Type arrayType = featureValue.getFeature().getRange();
                    CreateFeatureStructureDialog createArrayDialog = new CreateFeatureStructureDialog(Display.getCurrent().getActiveShell(), arrayType, EditViewPage.this.document.getCAS().getTypeSystem());
                    int returnCode = createArrayDialog.open();
                    if (returnCode == 0) {
                        newValue = this.createFS(arrayType, createArrayDialog.getArraySize());
                    } else {
                        return;
                    }
                }
                featureValue.getFeatureStructure().setFeatureValue(featureValue.getFeature(), newValue);
                EditViewPage.this.document.update(featureValue.getFeatureStructure());
            } else if (selection.getFirstElement() instanceof ArrayValue) {
                ArrayValue value = (ArrayValue)selection.getFirstElement();
                TypeSystem typeSystem = EditViewPage.this.document.getCAS().getTypeSystem();
                CreateFeatureStructureDialog createFsDialog = new CreateFeatureStructureDialog(Display.getCurrent().getActiveShell(), typeSystem.getType("uima.cas.TOP"), typeSystem);
                int returnCode = createFsDialog.open();
                if (returnCode == 0) {
                    FeatureStructure fs = this.createFS(createFsDialog.getType(), createFsDialog.getArraySize());
                    ArrayFS array = (ArrayFS)value.getFeatureStructure();
                    array.set(value.slot(), fs);
                    EditViewPage.this.document.update(value.getFeatureStructure());
                }
            }
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            boolean result = false;
            if (selection.size() == 1) {
                ArrayFS array;
                ArrayValue value;
                if (selection.getFirstElement() instanceof FeatureValue) {
                    FeatureValue featureValue = (FeatureValue)selection.getFirstElement();
                    result = !featureValue.getFeature().getRange().isPrimitive() && featureValue.getFeatureStructure().getFeatureValue(featureValue.getFeature()) == null;
                } else if (selection.getFirstElement() instanceof ArrayValue && (value = (ArrayValue)selection.getFirstElement()).getFeatureStructure() instanceof ArrayFS && (array = (ArrayFS)value.getFeatureStructure()).get(value.slot()) == null) {
                    result = true;
                }
            }
            return result;
        }
    }

    final class DeleteFeatureStructureValue
    extends BaseSelectionListenerAction {
        protected DeleteFeatureStructureValue() {
            super("Delete");
            this.setEnabled(false);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)EditViewPage.this.viewer.getSelection();
            Object element = selection.getFirstElement();
            if (element instanceof FeatureValue) {
                FeatureValue featureValue = (FeatureValue)element;
                if (!featureValue.getFeature().getRange().isPrimitive()) {
                    featureValue.getFeatureStructure().setFeatureValue(featureValue.getFeature(), null);
                    EditViewPage.this.document.update(featureValue.getFeatureStructure());
                }
            } else if (element instanceof ArrayValue) {
                ArrayValue arrayValue = (ArrayValue)element;
                ArrayFS array = (ArrayFS)arrayValue.getFeatureStructure();
                array.set(arrayValue.slot(), null);
                EditViewPage.this.document.update((FeatureStructure)array);
            }
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            boolean result = false;
            if (selection.size() == 1) {
                ArrayValue arrayValue;
                if (selection.getFirstElement() instanceof FeatureValue) {
                    FeatureValue featureValue = (FeatureValue)selection.getFirstElement();
                    result = !featureValue.getFeature().getRange().isPrimitive() && featureValue.getFeatureStructure().getFeatureValue(featureValue.getFeature()) != null;
                } else if (selection.getFirstElement() instanceof ArrayValue && (arrayValue = (ArrayValue)selection.getFirstElement()).getFeatureStructure() instanceof ArrayFS) {
                    ArrayFS array = (ArrayFS)arrayValue.getFeatureStructure();
                    result = array.get(arrayValue.slot()) != null;
                }
            }
            return result;
        }
    }

    private final class ValueEditingSupport
    extends EditingSupport {
        private ValueEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            if (element instanceof FeatureValue) {
                FeatureValue value = (FeatureValue)element;
                return value.getFeature().getRange().isPrimitive();
            }
            if (element instanceof ArrayValue) {
                ArrayValue value = (ArrayValue)element;
                FeatureStructure arrayFS = value.getFeatureStructure();
                if (arrayFS instanceof ArrayFS) {
                    return false;
                }
                if (arrayFS instanceof CommonArrayFS || arrayFS instanceof StringArrayFS) {
                    return true;
                }
                throw new CasEditorError("Unkown array type");
            }
            throw new CasEditorError("Unkown element type!");
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof FeatureValue) {
                FeatureValue value = (FeatureValue)element;
                if (value.getFeature().getRange().isPrimitive()) {
                    TextCellEditor editor;
                    if (value.getFeature().getRange().getName().equals("uima.cas.Boolean")) {
                        editor = new CheckboxCellEditor((Composite)EditViewPage.this.viewer.getTree(), 32);
                    } else {
                        editor = new TextCellEditor((Composite)EditViewPage.this.viewer.getTree());
                        editor.setValidator(CellEditorValidatorFacotory.createValidator(Primitives.getPrimitiveClass(value.getFeatureStructure().getCAS().getTypeSystem(), value.getFeature())));
                    }
                    return editor;
                }
                return null;
            }
            if (element instanceof ArrayValue) {
                TextCellEditor editor;
                ArrayValue arrayValue = (ArrayValue)element;
                FeatureStructure arrayFS = arrayValue.getFeatureStructure();
                if (arrayFS instanceof BooleanArrayFS) {
                    editor = new CheckboxCellEditor((Composite)EditViewPage.this.viewer.getTree(), 32);
                } else {
                    editor = new TextCellEditor((Composite)EditViewPage.this.viewer.getTree());
                    if (arrayFS instanceof ByteArrayFS) {
                        editor.setValidator(CellEditorValidatorFacotory.createValidator(Byte.class));
                    } else if (arrayFS instanceof ShortArrayFS) {
                        editor.setValidator(CellEditorValidatorFacotory.createValidator(Short.class));
                    } else if (arrayFS instanceof IntArrayFS) {
                        editor.setValidator(CellEditorValidatorFacotory.createValidator(Integer.class));
                    } else if (arrayFS instanceof LongArrayFS) {
                        editor.setValidator(CellEditorValidatorFacotory.createValidator(Long.class));
                    } else if (arrayFS instanceof FloatArrayFS) {
                        editor.setValidator(CellEditorValidatorFacotory.createValidator(Float.class));
                    } else if (arrayFS instanceof DoubleArrayFS) {
                        editor.setValidator(CellEditorValidatorFacotory.createValidator(Double.class));
                    } else if (!(arrayFS instanceof StringArrayFS)) {
                        throw new CasEditorError("Unknown array type: " + arrayFS.getClass().getName());
                    }
                }
                return editor;
            }
            throw new CasEditorError("Unknown element type: " + element.getClass().getName());
        }

        protected Object getValue(Object element) {
            if (element instanceof FeatureValue) {
                FeatureValue featureValue = (FeatureValue)element;
                if (!featureValue.getFeature().getRange().getName().equals("uima.cas.Boolean")) {
                    return Primitives.getPrimitive(featureValue.getFeatureStructure(), featureValue.getFeature()).toString();
                }
                return Primitives.getPrimitive(featureValue.getFeatureStructure(), featureValue.getFeature());
            }
            if (element instanceof ArrayValue) {
                ArrayValue value = (ArrayValue)element;
                if (!(value.getFeatureStructure() instanceof BooleanArrayFS)) {
                    return value.get().toString();
                }
                return value.get();
            }
            throw new CasEditorError("Unkown element type!");
        }

        protected void setValue(Object element, Object value) {
            if (value != null) {
                if (element instanceof FeatureValue) {
                    FeatureValue featureValue = (FeatureValue)element;
                    if (!featureValue.getFeature().getRange().getName().equals("uima.cas.Boolean")) {
                        if (featureValue.getFeature().getRange().isPrimitive()) {
                            featureValue.getFeatureStructure().setFeatureValueFromString(featureValue.getFeature(), (String)value);
                        }
                    } else {
                        featureValue.getFeatureStructure().setBooleanValue(featureValue.getFeature(), ((Boolean)value).booleanValue());
                    }
                    EditViewPage.this.document.update(featureValue.getFeatureStructure());
                    EditViewPage.this.viewer.update(element, null);
                } else if (element instanceof ArrayValue) {
                    ArrayValue arrayValue = (ArrayValue)element;
                    if (!(arrayValue.getFeatureStructure() instanceof BooleanArrayFS)) {
                        arrayValue.set((String)value);
                    } else {
                        arrayValue.set(value.toString());
                    }
                    EditViewPage.this.document.update(arrayValue.getFeatureStructure());
                } else {
                    throw new CasEditorError("Unkown element type");
                }
            }
        }
    }
}

