/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config.shell;

import java.util.Map;
import java.util.Properties;
import org.apache.karaf.cellar.config.shell.completers.ClusterConfigCompleter;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="config-property-list", description="List the configurations in a cluster group")
@Service
public class PropListCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="pid", description="The configuration PID", required=true, multiValued=false)
    @Completion(value=ClusterConfigCompleter.class)
    String pid;

    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + this.groupName);
        if (clusterConfigurations != null && !clusterConfigurations.isEmpty()) {
            Properties properties = (Properties)clusterConfigurations.get(this.pid);
            if (properties == null || properties.isEmpty()) {
                System.err.println("Configuration PID " + this.pid + " not found in cluster group " + this.groupName);
            } else {
                System.out.println(String.format("Property list for configuration PID " + this.pid + " for cluster group " + this.groupName, new Object[0]));
                for (Object key : properties.keySet()) {
                    String value = properties.getProperty((String)key);
                    System.out.println("   " + key + " = " + value);
                }
            }
        } else {
            System.err.println("No configuration found in cluster group " + this.groupName);
        }
        return null;
    }
}

