/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpRestConsumerPath;
import org.apache.camel.http.common.HttpServletResolveConsumerStrategy;
import org.apache.camel.support.RestConsumerContextPathMatcher;

public class HttpRestServletResolveConsumerStrategy
extends HttpServletResolveConsumerStrategy {
    @Override
    public HttpConsumer resolve(HttpServletRequest request, Map<String, HttpConsumer> consumers) {
        HttpConsumer answer = null;
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        String method = request.getMethod();
        if (method == null) {
            return null;
        }
        ArrayList<HttpRestConsumerPath> paths = new ArrayList<HttpRestConsumerPath>();
        for (Map.Entry<String, HttpConsumer> entry : consumers.entrySet()) {
            paths.add(new HttpRestConsumerPath(entry.getValue()));
        }
        RestConsumerContextPathMatcher.ConsumerPath best = RestConsumerContextPathMatcher.matchBestPath((String)method, (String)path, paths);
        if (best != null) {
            answer = (HttpConsumer)((Object)best.getConsumer());
        }
        if (answer == null) {
            answer = super.resolve(request, consumers);
        }
        return answer;
    }
}

