/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

public class DeferProducer
extends ServiceSupport
implements Producer,
AsyncProcessor {
    private Producer delegate;
    private final Endpoint endpoint;

    public DeferProducer(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public Exchange createExchange() {
        if (this.delegate == null) {
            throw new IllegalStateException("Not started");
        }
        return this.delegate.createExchange();
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        if (this.delegate == null) {
            throw new IllegalStateException("Not started");
        }
        return this.delegate.createExchange(pattern);
    }

    @Override
    @Deprecated
    public Exchange createExchange(Exchange exchange) {
        if (this.delegate == null) {
            throw new IllegalStateException("Not started");
        }
        return this.delegate.createExchange(exchange);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.delegate == null) {
            throw new IllegalStateException("Not started");
        }
        this.delegate.process(exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.delegate == null) {
            exchange.setException(new IllegalStateException("Not started"));
            callback.done(true);
            return true;
        }
        if (this.delegate instanceof AsyncProcessor) {
            return ((AsyncProcessor)((Object)this.delegate)).process(exchange, callback);
        }
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        Endpoint lookup = this.endpoint.getCamelContext().getEndpoint(this.endpoint.getEndpointUri());
        this.delegate = lookup.createProducer();
        ServiceHelper.startService(this.delegate);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.delegate);
    }

    @Override
    public boolean isSingleton() {
        if (this.delegate != null) {
            return this.delegate.isSingleton();
        }
        return true;
    }

    @Override
    public Endpoint getEndpoint() {
        if (this.delegate != null) {
            return this.delegate.getEndpoint();
        }
        return this.endpoint;
    }

    public String toString() {
        if (this.delegate != null) {
            return this.delegate.toString();
        }
        return "DelegateProducer[" + this.endpoint + "]";
    }
}

