/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.backoff;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.camel.util.backoff.BackOff;
import org.apache.camel.util.backoff.BackOffTimerTask;
import org.apache.camel.util.function.ThrowingFunction;

public class BackOffTimer {
    private final ScheduledExecutorService scheduler;

    public BackOffTimer(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public Task schedule(BackOff backOff, ThrowingFunction<Task, Boolean, Exception> function) {
        BackOffTimerTask task = new BackOffTimerTask(backOff, this.scheduler, function);
        long delay = task.next();
        if (delay != -1L) {
            this.scheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
        } else {
            task.cancel();
        }
        return task;
    }

    public static interface Task {
        public BackOff getBackOff();

        public Status getStatus();

        public long getCurrentAttempts();

        public long getCurrentDelay();

        public long getCurrentElapsedTime();

        public long getLastAttemptTime();

        public long getNextAttemptTime();

        public void reset();

        public void cancel();

        public void whenComplete(BiConsumer<Task, Throwable> var1);

        public static enum Status {
            Active,
            Inactive,
            Exhausted;

        }
    }
}

