/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.loader;

import java.util.Map;
import java.util.Timer;
import org.javamoney.moneta.internal.loader.DefaultLoaderListener;
import org.javamoney.moneta.internal.loader.LoadDataLoaderService;
import org.javamoney.moneta.internal.loader.LoadDataLocalLoaderService;
import org.javamoney.moneta.internal.loader.LoadRemoteDataLoaderService;
import org.javamoney.moneta.internal.loader.LoadableResource;
import org.javamoney.moneta.internal.loader.ScheduledDataLoaderService;

class DefaultLoaderServiceFacade {
    private final ScheduledDataLoaderService scheduledDataLoaderService;
    private final LoadDataLoaderService loadDataLoaderService;
    private final LoadDataLocalLoaderService loadDataLocalLoaderService;
    private final LoadRemoteDataLoaderService loadRemoteDataLoaderService;

    DefaultLoaderServiceFacade(Timer timer, DefaultLoaderListener listener, Map<String, LoadableResource> resources) {
        this.scheduledDataLoaderService = new ScheduledDataLoaderService(timer);
        this.loadDataLoaderService = new LoadDataLoaderService(listener);
        this.loadDataLocalLoaderService = new LoadDataLocalLoaderService(resources, listener);
        this.loadRemoteDataLoaderService = new LoadRemoteDataLoaderService(listener);
    }

    public void scheduledData(LoadableResource load) {
        this.scheduledDataLoaderService.execute(load);
    }

    public boolean loadData(String resourceId, Map<String, LoadableResource> resources) {
        return this.loadDataLoaderService.execute(resourceId, resources);
    }

    public boolean loadDataLocal(String resourceId) {
        return this.loadDataLocalLoaderService.execute(resourceId);
    }

    public boolean loadDataRemote(String resourceId, Map<String, LoadableResource> resources) {
        return this.loadRemoteDataLoaderService.execute(resourceId, resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DefaultLoaderServiceFacade.class.getName()).append('{').append(" scheduledDataLoaderService: ").append(this.scheduledDataLoaderService).append(',').append(" asyncLoaderService: ").append(this.loadDataLoaderService).append(',').append(" loadDataLocalLoaderService: ").append(this.loadDataLocalLoaderService).append(',');
        return sb.toString();
    }
}

