/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.rankeval.RatedDocument;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class RatedRequest
implements Writeable,
ToXContentObject {
    private final String id;
    private final List<String> summaryFields;
    private final List<RatedDocument> ratedDocs;
    @Nullable
    private final SearchSourceBuilder evaluationRequest;
    private final Map<String, Object> params;
    @Nullable
    private String templateId;
    private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField REQUEST_FIELD = new ParseField("request", new String[0]);
    private static final ParseField RATINGS_FIELD = new ParseField("ratings", new String[0]);
    private static final ParseField PARAMS_FIELD = new ParseField("params", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("summary_fields", new String[0]);
    private static final ParseField TEMPLATE_ID_FIELD = new ParseField("template_id", new String[0]);
    private static final ConstructingObjectParser<RatedRequest, Void> PARSER = new ConstructingObjectParser("request", a -> new RatedRequest((String)a[0], (List)a[1], (SearchSourceBuilder)a[2], (Map)a[3], (String)a[4]));

    public RatedRequest(String id, List<RatedDocument> ratedDocs, Map<String, Object> params, String templateId) {
        this(id, ratedDocs, null, params, templateId);
    }

    public RatedRequest(String id, List<RatedDocument> ratedDocs, SearchSourceBuilder evaluatedQuery) {
        this(id, ratedDocs, evaluatedQuery, new HashMap<String, Object>(), null);
    }

    private RatedRequest(String id, List<RatedDocument> ratedDocs, SearchSourceBuilder evaluatedQuery, Map<String, Object> params, String templateId) {
        if (params != null && params.size() > 0 && evaluatedQuery != null) {
            throw new IllegalArgumentException("Ambiguous rated request: Set both, verbatim test request and test request template parameters.");
        }
        if (templateId != null && evaluatedQuery != null) {
            throw new IllegalArgumentException("Ambiguous rated request: Set both, verbatim test request and test request template parameters.");
        }
        if ((params == null || params.size() < 1) && evaluatedQuery == null) {
            throw new IllegalArgumentException("Need to set at least test request or test request template parameters.");
        }
        if (params != null && params.size() > 0 && templateId == null) {
            throw new IllegalArgumentException("If template parameters are supplied need to set id of template to apply them to too.");
        }
        RatedRequest.validateEvaluatedQuery(evaluatedQuery);
        HashSet<RatedDocument.DocumentKey> docKeys = new HashSet<RatedDocument.DocumentKey>();
        for (RatedDocument doc : ratedDocs) {
            if (docKeys.add(doc.getKey())) continue;
            String docKeyToString = doc.getKey().toString().replaceAll("\n", "").replaceAll("  ", " ");
            throw new IllegalArgumentException("Found duplicate rated document key [" + docKeyToString + "] in evaluation request [" + id + "]");
        }
        this.id = id;
        this.evaluationRequest = evaluatedQuery;
        this.ratedDocs = new ArrayList<RatedDocument>(ratedDocs);
        this.params = params != null ? new HashMap<String, Object>(params) : Collections.emptyMap();
        this.templateId = templateId;
        this.summaryFields = new ArrayList<String>();
    }

    static void validateEvaluatedQuery(SearchSourceBuilder evaluationRequest) {
        if (evaluationRequest != null) {
            if (evaluationRequest.suggest() != null) {
                throw new IllegalArgumentException("Query in rated requests should not contain a suggest section.");
            }
            if (evaluationRequest.aggregations() != null) {
                throw new IllegalArgumentException("Query in rated requests should not contain aggregations.");
            }
            if (evaluationRequest.highlighter() != null) {
                throw new IllegalArgumentException("Query in rated requests should not contain a highlighter section.");
            }
            if (evaluationRequest.explain() != null && evaluationRequest.explain().booleanValue()) {
                throw new IllegalArgumentException("Query in rated requests should not use explain.");
            }
            if (evaluationRequest.profile()) {
                throw new IllegalArgumentException("Query in rated requests should not use profile.");
            }
        }
    }

    RatedRequest(StreamInput in) throws IOException {
        this.id = in.readString();
        this.evaluationRequest = in.readOptionalWriteable(SearchSourceBuilder::new);
        int intentSize = in.readInt();
        this.ratedDocs = new ArrayList<RatedDocument>(intentSize);
        for (int i = 0; i < intentSize; ++i) {
            this.ratedDocs.add(new RatedDocument(in));
        }
        this.params = in.readMap();
        int summaryFieldsSize = in.readInt();
        this.summaryFields = new ArrayList<String>(summaryFieldsSize);
        for (int i = 0; i < summaryFieldsSize; ++i) {
            this.summaryFields.add(in.readString());
        }
        this.templateId = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalWriteable(this.evaluationRequest);
        out.writeInt(this.ratedDocs.size());
        for (RatedDocument ratedDoc : this.ratedDocs) {
            ratedDoc.writeTo(out);
        }
        out.writeMap(this.params);
        out.writeInt(this.summaryFields.size());
        for (String fieldName : this.summaryFields) {
            out.writeString(fieldName);
        }
        out.writeOptionalString(this.templateId);
    }

    public SearchSourceBuilder getEvaluationRequest() {
        return this.evaluationRequest;
    }

    public String getId() {
        return this.id;
    }

    public List<RatedDocument> getRatedDocs() {
        return Collections.unmodifiableList(this.ratedDocs);
    }

    public Map<String, Object> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public List<String> getSummaryFields() {
        return Collections.unmodifiableList(this.summaryFields);
    }

    public void addSummaryFields(List<String> summaryFields) {
        this.summaryFields.addAll((Collection<String>)Objects.requireNonNull(summaryFields, "no summary fields supplied"));
    }

    public static RatedRequest fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID_FIELD.getPreferredName(), this.id);
        if (this.evaluationRequest != null) {
            builder.field(REQUEST_FIELD.getPreferredName(), this.evaluationRequest);
        }
        builder.startArray(RATINGS_FIELD.getPreferredName());
        for (RatedDocument ratedDocument : this.ratedDocs) {
            ratedDocument.toXContent(builder, params);
        }
        builder.endArray();
        if (this.templateId != null) {
            builder.field(TEMPLATE_ID_FIELD.getPreferredName(), this.templateId);
        }
        if (!this.params.isEmpty()) {
            builder.startObject(PARAMS_FIELD.getPreferredName());
            for (Map.Entry entry : this.params.entrySet()) {
                builder.field((String)entry.getKey(), entry.getValue());
            }
            builder.endObject();
        }
        if (!this.summaryFields.isEmpty()) {
            builder.startArray(FIELDS_FIELD.getPreferredName());
            for (String string : this.summaryFields) {
                builder.value(string);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RatedRequest other = (RatedRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.evaluationRequest, other.evaluationRequest) && Objects.equals(this.summaryFields, other.summaryFields) && Objects.equals(this.ratedDocs, other.ratedDocs) && Objects.equals(this.params, other.params) && Objects.equals(this.templateId, other.templateId);
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.evaluationRequest, this.summaryFields, this.ratedDocs, this.params, this.templateId);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> RatedDocument.fromXContent(p), RATINGS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchSourceBuilder.fromXContent(p, false), REQUEST_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), PARAMS_FIELD);
        PARSER.declareStringArray(RatedRequest::addSummaryFields, FIELDS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TEMPLATE_ID_FIELD);
    }
}

