/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.persistence.spi.PropertyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateVisitPropertiesAction
implements ActionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EvaluateVisitPropertiesAction.class.getName());

    public int execute(Action action, Event event) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date currentEventTimeStamp = event.getTimeStamp();
        Date currentProfileFirstVisit = this.extractDateFromProperty(event.getProfile(), "firstVisit", dateFormat);
        Date currentProfilePreviousVisit = this.extractDateFromProperty(event.getProfile(), "previousVisit", dateFormat);
        Date currentProfileLastVisit = this.extractDateFromProperty(event.getProfile(), "lastVisit", dateFormat);
        int result = 0;
        if (currentProfileFirstVisit == null || currentProfileFirstVisit.after(currentEventTimeStamp)) {
            int n = result = PropertyHelper.setProperty((Object)event.getProfile(), (String)"properties.firstVisit", (Object)dateFormat.format(currentEventTimeStamp), (String)"alwaysSet") ? 4 : result;
        }
        if (currentProfileLastVisit == null || currentProfileLastVisit.before(currentEventTimeStamp)) {
            if (PropertyHelper.setProperty((Object)event.getProfile(), (String)"properties.lastVisit", (Object)dateFormat.format(currentEventTimeStamp), (String)"alwaysSet")) {
                result = 4;
                if (currentProfileLastVisit != null) {
                    PropertyHelper.setProperty((Object)event.getProfile(), (String)"properties.previousVisit", (Object)dateFormat.format(currentProfileLastVisit), (String)"alwaysSet");
                }
            }
        } else if (currentProfilePreviousVisit != null && currentProfilePreviousVisit.before(currentEventTimeStamp)) {
            result = PropertyHelper.setProperty((Object)event.getProfile(), (String)"properties.previousVisit", (Object)dateFormat.format(currentEventTimeStamp), (String)"alwaysSet") ? 4 : result;
        }
        return result;
    }

    private Date extractDateFromProperty(Profile profile, String propertyName, DateFormat dateFormat) {
        Object property = profile.getProperties().get(propertyName);
        Date date = null;
        try {
            if (property != null) {
                date = property instanceof String ? dateFormat.parse((String)property) : (property instanceof Date ? (Date)property : dateFormat.parse(property.toString()));
            }
        }
        catch (ParseException e) {
            LOGGER.error("Error parsing {} date property. See debug log level for more information", (Object)propertyName);
            LOGGER.debug("Error parsing date: {}, on profile: {}", new Object[]{property, profile.getItemId(), e});
        }
        return date;
    }
}

