/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.internal.runners.CompositeRunner;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClassMethodsRunner;
import org.junit.internal.runners.TestClassRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameterized
extends TestClassRunner {
    public static Collection<Object[]> eachOne(Object ... params) {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (Object param : params) {
            results.add(new Object[]{param});
        }
        return results;
    }

    public Parameterized(Class<?> klass) throws Exception {
        super(klass, new RunAllParameterMethods(klass));
    }

    @Override
    protected void validate(MethodValidator methodValidator) {
        methodValidator.validateStaticMethods();
        methodValidator.validateInstanceMethods();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunAllParameterMethods
    extends CompositeRunner {
        private final Class<?> fKlass;

        public RunAllParameterMethods(Class<?> klass) throws Exception {
            super(klass.getName());
            this.fKlass = klass;
            int i = 0;
            for (Object each : this.getParametersList()) {
                if (each instanceof Object[]) {
                    super.add(new TestClassRunnerForParameters(klass, (Object[])each, i++));
                    continue;
                }
                throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.fKlass.getName(), this.getParametersMethod().getName()));
            }
        }

        private Collection<?> getParametersList() throws IllegalAccessException, InvocationTargetException, Exception {
            return (Collection)this.getParametersMethod().invoke(null, new Object[0]);
        }

        private Method getParametersMethod() throws Exception {
            for (Method each : this.fKlass.getMethods()) {
                Annotation[] annotations;
                if (!Modifier.isStatic(each.getModifiers())) continue;
                for (Annotation annotation : annotations = each.getAnnotations()) {
                    if (annotation.annotationType() != Parameters.class) continue;
                    return each;
                }
            }
            throw new Exception("No public static parameters method on class " + this.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestClassRunnerForParameters
    extends TestClassMethodsRunner {
        private final Object[] fParameters;
        private final int fParameterSetNumber;
        private final Constructor<?> fConstructor;

        private TestClassRunnerForParameters(Class<?> klass, Object[] parameters, int i) {
            super(klass);
            this.fParameters = parameters;
            this.fParameterSetNumber = i;
            this.fConstructor = this.getOnlyConstructor();
        }

        @Override
        protected Object createTest() throws Exception {
            return this.fConstructor.newInstance(this.fParameters);
        }

        @Override
        protected String getName() {
            return String.format("[%s]", this.fParameterSetNumber);
        }

        @Override
        protected String testName(Method method) {
            return String.format("%s[%s]", method.getName(), this.fParameterSetNumber);
        }

        private Constructor<?> getOnlyConstructor() {
            Constructor<?>[] constructors = this.getTestClass().getConstructors();
            Assert.assertEquals(1, constructors.length);
            return constructors[0];
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
    }
}

