/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.wizard.IDefaultButtonProvider;
import org.apache.wicket.extensions.wizard.IWizard;
import org.apache.wicket.extensions.wizard.IWizardModel;
import org.apache.wicket.extensions.wizard.IWizardModelListener;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardButtonBar;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;

public class Wizard
extends Panel
implements IWizardModelListener,
IWizard {
    public static final String BUTTONS_ID = "buttons";
    public static final String FEEDBACK_ID = "feedback";
    public static final String HEADER_ID = "header";
    public static final String OVERVIEW_ID = "overview";
    public static final String FORM_ID = "form";
    public static final String VIEW_ID = "view";
    private static final long serialVersionUID = 1L;
    private Form<?> form;
    private IWizardModel wizardModel;

    public Wizard(String id) {
        super(id);
    }

    public Wizard(String id, IWizardModel wizardModel) {
        super(id);
        this.init(wizardModel);
    }

    public final IWizardStep getActiveStep() {
        return this.getWizardModel().getActiveStep();
    }

    public Form<?> getForm() {
        return this.form;
    }

    @Override
    public final IWizardModel getWizardModel() {
        return this.wizardModel;
    }

    public boolean isVersioned() {
        return false;
    }

    @Override
    public void onActiveStepChanged(IWizardStep newStep) {
        this.form.replace(newStep.getView(VIEW_ID, (Component)this, this));
        this.form.replace(newStep.getHeader(HEADER_ID, (Component)this, this));
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onFinish() {
    }

    protected void init(IWizardModel wizardModel) {
        if (wizardModel == null) {
            throw new IllegalArgumentException("argument wizardModel must be not null");
        }
        this.wizardModel = wizardModel;
        this.form = this.newForm(FORM_ID);
        this.addOrReplace(new Component[]{this.form});
        this.form.addOrReplace(new Component[]{new WebMarkupContainer(HEADER_ID)});
        this.form.addOrReplace(new Component[]{this.newFeedbackPanel(FEEDBACK_ID)});
        this.form.addOrReplace(new Component[]{new WebMarkupContainer(VIEW_ID)});
        this.form.addOrReplace(new Component[]{this.newButtonBar(BUTTONS_ID)});
        this.form.addOrReplace(new Component[]{this.newOverviewBar(OVERVIEW_ID)});
        wizardModel.addListener(this);
        wizardModel.reset();
    }

    protected Component newButtonBar(String id) {
        return new WizardButtonBar(id, this);
    }

    protected Component newFeedbackPanel(String id) {
        return new FeedbackPanel(id, (IFeedbackMessageFilter)new ContainerFeedbackMessageFilter((MarkupContainer)this));
    }

    protected <E> Form<E> newForm(String id) {
        return new Form(id);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        Component buttonBar = this.form.get(BUTTONS_ID);
        if (buttonBar instanceof IDefaultButtonProvider) {
            IFormSubmittingComponent defaultButton = ((IDefaultButtonProvider)buttonBar).getDefaultButton(this.wizardModel);
            this.form.setDefaultButton(defaultButton);
        }
    }

    protected Component newOverviewBar(String id) {
        return new WebMarkupContainer(id).setVisible(false);
    }
}

