/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.util.time.Duration;

public abstract class AbstractAjaxTimerBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private Duration updateInterval;
    private boolean stopped = false;

    public AbstractAjaxTimerBehavior(Duration updateInterval) {
        this.setUpdateInterval(updateInterval);
    }

    protected final void setUpdateInterval(Duration updateInterval) {
        if (updateInterval == null || updateInterval.getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("Invalid update interval");
        }
        this.updateInterval = updateInterval;
    }

    public final Duration getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (!this.isStopped()) {
            this.addTimeout(response);
        }
    }

    protected final String getJsTimeoutCall(Duration updateInterval) {
        CharSequence js = this.getCallbackScript();
        return String.format("Wicket.Timer.set('%s', function(){%s}, %d);", this.getComponent().getMarkupId(), js, updateInterval.getMilliseconds());
    }

    @Override
    protected final void respond(AjaxRequestTarget target) {
        if (this.shouldTrigger()) {
            this.onTimer(target);
            if (this.shouldTrigger()) {
                this.addTimeout(target.getHeaderResponse());
                return;
            }
        }
        this.clearTimeout(target.getHeaderResponse());
    }

    protected boolean shouldTrigger() {
        return !this.isStopped() && this.isEnabled(this.getComponent()) && (this.getComponent() instanceof Page || this.getComponent().findParent(Page.class) != null);
    }

    protected abstract void onTimer(AjaxRequestTarget var1);

    public final boolean isStopped() {
        return this.stopped;
    }

    public final void restart(IPartialPageRequestHandler target) {
        if (this.stopped) {
            this.stopped = false;
            if (target != null) {
                this.addTimeout(target.getHeaderResponse());
            }
        }
    }

    private void addTimeout(IHeaderResponse headerResponse) {
        headerResponse.render(OnLoadHeaderItem.forScript(this.getJsTimeoutCall(this.updateInterval)));
    }

    private void clearTimeout(IHeaderResponse headerResponse) {
        headerResponse.render(OnLoadHeaderItem.forScript("Wicket.Timer.clear('" + this.getComponent().getMarkupId() + "');"));
    }

    public final void stop(IPartialPageRequestHandler target) {
        if (!this.stopped) {
            this.stopped = true;
            if (target != null) {
                this.clearTimeout(target.getHeaderResponse());
            }
        }
    }

    @Override
    public void onRemove(Component component) {
        IPartialPageRequestHandler target = component.getRequestCycle().find(IPartialPageRequestHandler.class);
        if (target != null) {
            this.clearTimeout(target.getHeaderResponse());
        }
    }

    @Override
    protected void onUnbind() {
        IPartialPageRequestHandler target = this.getComponent().getRequestCycle().find(IPartialPageRequestHandler.class);
        if (target != null) {
            this.clearTimeout(target.getHeaderResponse());
        }
    }
}

