/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.jetty9;

import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.AbstractUpgradeFilter;
import org.apache.wicket.protocol.ws.jetty9.Jetty9WebSocketProcessor;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty9WebSocketFilter
extends AbstractUpgradeFilter {
    private static final Logger LOG = LoggerFactory.getLogger(Jetty9WebSocketFilter.class);
    private WebSocketServerFactory _webSocketFactory;

    public Jetty9WebSocketFilter() {
    }

    public Jetty9WebSocketFilter(WebApplication application) {
        super(application);
    }

    public void init(boolean isServlet, FilterConfig filterConfig) throws ServletException {
        super.init(isServlet, filterConfig);
        try {
            String max;
            WebSocketPolicy serverPolicy = WebSocketPolicy.newServerPolicy();
            String bs = filterConfig.getInitParameter("inputBufferSize");
            if (bs != null) {
                serverPolicy.setInputBufferSize(Integer.parseInt(bs));
            }
            if ((max = filterConfig.getInitParameter("maxIdleTime")) != null) {
                serverPolicy.setIdleTimeout((long)Integer.parseInt(max));
            }
            if ((max = filterConfig.getInitParameter("maxMessageSize")) != null) {
                serverPolicy.setMaxMessageSize((long)Integer.parseInt(max));
            }
            this._webSocketFactory = new WebSocketServerFactory(serverPolicy);
            this._webSocketFactory.setCreator(new WebSocketCreator(){

                public Object createWebSocket(UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse) {
                    return new Jetty9WebSocketProcessor(upgradeRequest, upgradeResponse, Jetty9WebSocketFilter.this.getApplication());
                }
            });
            this._webSocketFactory.start();
        }
        catch (ServletException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected boolean acceptWebSocket(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        return super.acceptWebSocket(req, resp) && this._webSocketFactory.acceptWebSocket(req, resp);
    }

    public void destroy() {
        try {
            if (this._webSocketFactory != null) {
                this._webSocketFactory.stop();
            }
        }
        catch (Exception x) {
            LOG.warn("A problem occurred while stopping the web socket factory", (Throwable)x);
        }
        super.destroy();
    }
}

