/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.Page;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class BookmarkablePageLink<T>
extends Link<T> {
    private static final long serialVersionUID = 1L;
    private final String pageClassName;
    protected PageParameters parameters;

    public <C extends Page> BookmarkablePageLink(String id, Class<C> pageClass) {
        this(id, pageClass, null);
    }

    public PageParameters getPageParameters() {
        if (this.parameters == null) {
            this.parameters = new PageParameters();
        }
        return this.parameters;
    }

    public <C extends Page> BookmarkablePageLink(String id, Class<C> pageClass, PageParameters parameters) {
        super(id);
        this.parameters = parameters;
        if (pageClass == null) {
            throw new IllegalArgumentException("Page class for bookmarkable link cannot be null");
        }
        if (!Page.class.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("Page class must be derived from " + Page.class.getName());
        }
        this.pageClassName = pageClass.getName();
    }

    public final Class<? extends Page> getPageClass() {
        return WicketObjects.resolveClass(this.pageClassName);
    }

    @Override
    public boolean linksTo(Page page) {
        return page.getClass() == this.getPageClass();
    }

    @Override
    protected boolean getStatelessHint() {
        return true;
    }

    @Override
    public final void onClick() {
    }

    @Override
    protected CharSequence getURL() {
        PageParameters parameters = this.getPageParameters();
        return this.urlFor(this.getPageClass(), parameters);
    }
}

