/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import javax.enterprise.inject.spi.BeanManager;
import org.apache.wicket.Application;
import org.apache.wicket.cdi.BehaviorInjector;
import org.apache.wicket.cdi.CdiContainer;
import org.apache.wicket.cdi.CdiShutdownCleaner;
import org.apache.wicket.cdi.ComponentInjector;
import org.apache.wicket.cdi.ConversationExpiryChecker;
import org.apache.wicket.cdi.ConversationPropagation;
import org.apache.wicket.cdi.ConversationPropagator;
import org.apache.wicket.cdi.DetachEventEmitter;
import org.apache.wicket.cdi.IConversationPropagation;
import org.apache.wicket.cdi.INonContextualManager;
import org.apache.wicket.cdi.NonContextualManager;
import org.apache.wicket.cdi.SessionInjector;
import org.apache.wicket.request.cycle.RequestCycleListenerCollection;
import org.apache.wicket.util.lang.Args;
import org.jboss.seam.conversation.spi.SeamConversationContextFactory;

public class CdiConfiguration {
    private BeanManager beanManager;
    private IConversationPropagation propagation = ConversationPropagation.NONBOOKMARKABLE;
    private INonContextualManager nonContextualManager;
    private boolean injectComponents = true;
    private boolean injectApplication = true;
    private boolean injectSession = true;
    private boolean injectBehaviors = true;
    private boolean autoConversationManagement = false;

    public CdiConfiguration(BeanManager beanManager) {
        Args.notNull((Object)beanManager, (String)"beanManager");
        this.beanManager = beanManager;
        this.nonContextualManager = new NonContextualManager(beanManager);
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public IConversationPropagation getPropagation() {
        return this.propagation;
    }

    public boolean isAutoConversationManagement() {
        return this.autoConversationManagement;
    }

    public CdiConfiguration setAutoConversationManagement(boolean enabled) {
        this.autoConversationManagement = enabled;
        return this;
    }

    public CdiConfiguration setPropagation(IConversationPropagation propagation) {
        this.propagation = propagation;
        return this;
    }

    public INonContextualManager getNonContextualManager() {
        return this.nonContextualManager;
    }

    public CdiConfiguration setNonContextualManager(INonContextualManager nonContextualManager) {
        this.nonContextualManager = nonContextualManager;
        return this;
    }

    public boolean isInjectComponents() {
        return this.injectComponents;
    }

    public CdiConfiguration setInjectComponents(boolean injectComponents) {
        this.injectComponents = injectComponents;
        return this;
    }

    public boolean isInjectApplication() {
        return this.injectApplication;
    }

    public CdiConfiguration setInjectApplication(boolean injectApplication) {
        this.injectApplication = injectApplication;
        return this;
    }

    public boolean isInjectSession() {
        return this.injectSession;
    }

    public CdiConfiguration setInjectSession(boolean injectSession) {
        this.injectSession = injectSession;
        return this;
    }

    public boolean isInjectBehaviors() {
        return this.injectBehaviors;
    }

    public CdiConfiguration setInjectBehaviors(boolean injectBehaviors) {
        this.injectBehaviors = injectBehaviors;
        return this;
    }

    public CdiContainer configure(Application application) {
        if (this.beanManager == null) {
            throw new IllegalStateException("Configuration does not have a BeanManager instance configured");
        }
        CdiContainer container = new CdiContainer(this.beanManager, this.nonContextualManager);
        container.bind(application);
        RequestCycleListenerCollection listeners = new RequestCycleListenerCollection();
        application.getRequestCycleListeners().add((Object)listeners);
        if (this.getPropagation() != ConversationPropagation.NONE) {
            listeners.add((Object)new ConversationPropagator(application, container, this.getPropagation(), this.autoConversationManagement));
            application.getComponentPreOnBeforeRenderListeners().add((Object)new ConversationExpiryChecker(container));
            SeamConversationContextFactory.setDisableNoopInstance((boolean)true);
        }
        listeners.add((Object)new DetachEventEmitter(container));
        if (this.isInjectApplication()) {
            container.getNonContextualManager().postConstruct(application);
        }
        if (this.isInjectSession()) {
            application.getSessionListeners().add((Object)new SessionInjector(container));
        }
        if (this.isInjectComponents()) {
            application.getComponentInstantiationListeners().add((Object)new ComponentInjector(container));
        }
        if (this.isInjectBehaviors()) {
            application.getBehaviorInstantiationListeners().add((Object)new BehaviorInjector(container));
        }
        application.getApplicationListeners().add((Object)new CdiShutdownCleaner(this.beanManager, this.isInjectApplication()));
        return container;
    }
}

